{
    achievements {
        data [

            { id "ach_apartments_1" steam "ach_apartments_1" galaxy "ach_apartments_1" type ratings subid score-residential-luxury value 1 }
            { id "ach_apartments_2" steam "ach_apartments_2" galaxy "ach_apartments_2" type counttagged value 1 tags [ apt-four-a apt-four-b ] }
            { id "ach_art" steam "ach_art" galaxy "ach_art" type counttagged value 1 tags [ artworks ] }

            { id "ach_art_small" steam "ach_art_small" galaxy "ach_art_small" type counteachtemplate value 1 templates 
                [ painting-small-one painting-small-two painting-small-three sculpture-small-one sculpture-small-two sculpture-small-three ] }

            { id "ach_art_medium" steam "ach_art_medium" galaxy "ach_art_medium" type counteachtemplate value 1 templates
                [ painting-medium-one painting-medium-two painting-medium-three sculpture-medium-one sculpture-medium-two ] }

            { id "ach_art_large" steam "ach_art_large" galaxy "ach_art_large" type counteachtemplate value 1 templates 
                [ painting-mural sculpture-large-inside ] }

            { id "ach_plaza" steam "ach_plaza" galaxy "ach_plaza" type counttagged value 1 tags [ plaza ] }
            { id "ach_art_outside" steam "ach_art_outside" galaxy "ach_art_outside" type counteachtemplate value 1 templates
                [ statue-outdoor-one statue-outdoor-two statue-outdoor-three statue-outdoor-four ] }

            { id "ach_fountains" steam "ach_fountains" galaxy "ach_fountains" type counttagged value 1 tags [ fountains ] }
            { id "ach_deco" steam "ach_deco" galaxy "ach_deco" type specialwallpaper }
            { id "ach_buzz" steam "ach_buzz" galaxy "ach_buzz" type buzz sub buzztotalcampaigns value 1 }
            { id "ach_campaigns_1" steam "ach_campaigns_1" galaxy "ach_campaigns_1" type buzz sub buzzcampaign subid "goldenage.category.apartments" }
            { id "ach_campaigns_2" steam "ach_campaigns_2" galaxy "ach_campaigns_2" type buzz sub buzzcampaign subid "goldenage.category.infrastructure" }
            { id "ach_campaigns_3" steam "ach_campaigns_3" galaxy "ach_campaigns_3" type buzz sub buzzcampaign subid "goldenage.category.commercial" }
            { id "ach_campaings_4" steam "ach_campaings_4" galaxy "ach_campaings_4" type buzz sub buzzcampaign subid "goldenage.category.offices" }
            { id "ach_floors" steam "ach_floors" galaxy "ach_floors" type boardstats sub boardstatsfloors value 5 }
            { id "ach_floors_1" steam "ach_floors_1" galaxy "ach_floors_1" type boardstats sub boardstatsfloors value 50 }
            { id "ach_floors_2" steam "ach_floors_2" galaxy "ach_floors_2" type boardstats sub boardstatsfloors value 100 }
            { id "ach_area" steam "ach_area" galaxy "ach_area" type boardstats sub boardstatstiles value 500 }
            { id "ach_area_1" steam "ach_area_1" galaxy "ach_area_1" type boardstats sub boardstatstiles value 2500 }
            { id "ach_contracts_1" steam "ach_contracts_1" galaxy "ach_contracts_1" type contracts subid office-level-four value 1 }
            { id "ach_contracts_2" steam "ach_contracts_2" galaxy "ach_contracts_2" type contracts subid apartments-four value 1 }
            { id "ach_contracts_3" steam "ach_contracts_3" galaxy "ach_contracts_3" type contracts subid restaurant-gourmet value 1 }
            { id "ach_contracts_4" steam "ach_contracts_4" galaxy "ach_contracts_4" type contracts subid retail-lux value 1 }
            { id "ach_tutorial" steam "ach_tutorial" galaxy "ach_tutorial" type specialtutorials }
            { id "ach_ada" steam "ach_ada" galaxy "ach_ada" type specialada }
            { id "ach_consultant" steam "ach_consultant" galaxy "ach_consultant" type counttagged value 1 tags [ consultant ] }
            { id "ach_consultant_1" steam "ach_consultant_1" galaxy "ach_consultant_1" type consultants sub consultantupgradeany }
            { id "ach_consultants_a" steam "ach_consultants_a" galaxy "ach_consultants_a" type consultants sub consultantupgrade subid "cons-a-5" }
            { id "ach_consultants_b" steam "ach_consultants_b" galaxy "ach_consultants_b" type consultants sub consultantupgrade subid "cons-b-5" }
            { id "ach_consultants_c" steam "ach_consultants_c" galaxy "ach_consultants_c" type consultants sub consultantupgrade subid "cons-c-5" }
            { id "ach_trash_1" steam "ach_trash_1" galaxy "ach_trash_1" type daily sub dailytrashoverflow templates [ "support-recycle" ] }
            { id "ach_recycling_1" steam "ach_recycling_1" galaxy "ach_recycling_1" type daily sub dailytrashoverflow templates [ "support-trashroom" ] }
            { id "ach_grime" steam "ach_grime" galaxy "ach_grime" type renovate sub renovateany }
            { id "ach_grime_1" steam "ach_grime_1" galaxy "ach_grime_1" type renovate sub renovateall }
            { id "ach_grime_2" steam "ach_grime_2" galaxy "ach_grime_2" type counttagged value 1 tags [ support-maintenance-expanded ] }
            { id "ach_support_1" steam "ach_support_1" galaxy "ach_support_1" type daily sub dailyservicesuccess value 250 }
            { id "ach_mod_1" steam "ach_mod_1" galaxy "ach_mod_1" type mods sub moddownload }
            { id "ach_mod_2" steam "ach_mod_2" galaxy "ach_mod_2" type mods sub moduse }
            { id "ach_cash" steam "ach_cash" galaxy "ach_cash" type daily sub dailycash value 1000000 }
            { id "ach_revs_1" steam "ach_revs_1" galaxy "ach_revs_1" type daily sub dailyrevs value 50000 }
            { id "ach_revs_2" steam "ach_revs_2" galaxy "ach_revs_2" type daily sub dailyrevs value 100000 }
            { id "ach_revs_3" steam "ach_revs_3" galaxy "ach_revs_3" type daily sub dailyrevs value 200000 }
            { id "ach_profit_0" steam "ach_profit_0" galaxy "ach_profit_0" type daily sub dailyprofit value 1 }
            { id "ach_profit_1" steam "ach_profit_1" galaxy "ach_profit_1" type daily sub dailyprofit value 25000 }
            { id "ach_profit_2" steam "ach_profit_2" galaxy "ach_profit_2" type daily sub dailyprofit value 50000 }
            { id "ach_loan" steam "ach_loan" galaxy "ach_loan" type loans sub loanrepaid }
            { id "ach_drones"   steam "ach_drones" galaxy "ach_drones" type daily sub dailyofficepop value 500 }
            { id "ach_office_1" steam "ach_office_1" galaxy "ach_office_1" type ratings subid score-office-technical value 1 }
            { id "ach_office_2" steam "ach_office_2" galaxy "ach_office_2" type counttagged value 1 tags [ office-four ] }
            { id "ach_pop_1" steam "ach_pop_1" galaxy "ach_pop_1" type daily sub dailypop value 250 }
            { id "ach_pop_2" steam "ach_pop_2" galaxy "ach_pop_2" type daily sub dailypop value 500 }
            { id "ach_renters" steam "ach_renters" galaxy "ach_renters" type daily sub dailyapartmentpop value 300 }
            { id "ach_100days" steam "ach_100days" galaxy "ach_100days" type daily sub dailyunitsold value 100 }
            { id "ach_happy" steam "ach_happy" galaxy "ach_happy" type daily sub dailyunitshappy value 200 }
            { id "ach_veryhappy" steam "ach_veryhappy" galaxy "ach_veryhappy" type daily sub dailyunitsveryhappy value 50 }
            { id "ach_nomoveout" steam "ach_nomoveout" galaxy "ach_nomoveout" type daily sub dailymoveoutage value 28 }
            { id "ach_visitors_1" steam "ach_visitors_1" galaxy "ach_visitors_1" type daily sub dailyvisitors value 100 }
            { id "ach_prestige_1" steam "ach_prestige_1" galaxy "ach_prestige_1" type daily sub dailyprestige value 10 }
            { id "ach_prestige_2" steam "ach_prestige_2" galaxy "ach_prestige_2" type daily sub dailyprestige value 20 }
            { id "ach_prestige_3" steam "ach_prestige_3" galaxy "ach_prestige_3" type daily sub dailyprestige value 50 }
            { id "ach_restaurants_1" steam "ach_restaurants_1" galaxy "ach_restaurants_1" type counttagged value 20 tags [ restaurant ] }
            { id "ach_restaurants_2" steam "ach_restaurants_2" galaxy "ach_restaurants_2" type daily sub dailyprofitablerestaurants value 10 }
            { id "ach_restaurants_3" steam "ach_restaurants_3" galaxy "ach_restaurants_3" type ratings subid score-restaurant-dinner value 1 }
            { id "ach_restaurants_4" steam "ach_restaurants_4" galaxy "ach_restaurants_4" type ratings subid score-restaurant-bar value 1 }
            { id "ach_restaurants_5" steam "ach_restaurants_5" galaxy "ach_restaurants_5" type ratings subid score-restaurant-gourmet value 1 }
            { id "ach_retail_1" steam "ach_retail_1" galaxy "ach_retail_1" type daily sub dailyprofitablestores value 10 }
            { id "ach_retail_2" steam "ach_retail_2" galaxy "ach_retail_2" type counttagged value 10 tags [ retail ] }
            { id "ach_retail_3" steam "ach_retail_3" galaxy "ach_retail_3" type ratings subid score-retail-large value 1 }
            { id "ach_retail_4" steam "ach_retail_4" galaxy "ach_retail_4" type ratings subid score-retail-luxury value 1 }
            { id "ach_scenarios_1" steam "ach_scenarios_1" galaxy "ach_scenarios_1" type goldmedals value 1 }
            { id "ach_scenarios_2" steam "ach_scenarios_2" galaxy "ach_scenarios_2" type goldmedals value 5 }
            { id "ach_scenarios_3" steam "ach_scenarios_3" galaxy "ach_scenarios_3" type goldmedals value 10 }
            { id "ach_util_power" steam "ach_util_power" galaxy "ach_util_power" type daily sub dailyutilpower value 200 }
            { id "ach_util_phone" steam "ach_util_phone" galaxy "ach_util_phone" type daily sub dailyutilphone value 200 }
            { id "ach_util_cable" steam "ach_util_cable" galaxy "ach_util_cable" type daily sub dailyutilcable value 100 }
            { id "ach_util_water" steam "ach_util_water" galaxy "ach_util_water" type daily sub dailyutilwater value 200 }
            { id "ach_util_gas" steam "ach_util_gas" galaxy "ach_util_gas" type daily sub dailyutilgas value 100 }
        ]
    }

    newgame {
        boards [ 
            ;; board dimensions must be equal or larger to lot dimensions
            {
                locname "board.standard"
                locdesc "board.standard.desc"
                def {
                    board { left -40 right 40 top 120 bottom -15 }
                    lot { left -35 right 35 top 60 bottom -10 floorspacecap 4000 }
                    caps { floorspacemax 8000 plazaupgradetiles 5 }
                }
            }
            {
                locname "board.narrow"
                locdesc "board.narrow.desc"
                def {
                    board { left -36 right 24 top 160 bottom -20 }
                    lot { left -16 right 16 top 80 bottom -10 floorspacecap 2400 }
                    caps { floorspacemax 5000 plazaupgradetiles 2 }
                }
            }
            {
                locname "board.short"
                locdesc "board.short.desc"
                def {
                    board { left -82 right 82 top 25 bottom -15 }
                    lot { left -75 right 75 top 18 bottom -10 floorspacecap 3000 }
                    caps { floorspacemax 4500 plazaupgradetiles 8 }
                }
            }
            {
                locname "board.xl"
                locdesc "board.xl.desc"
                def {
                    board { left -110 right 110 top 80 bottom -25 }
                    lot { left -90 right 90 top 40 bottom -20 floorspacecap 6000 }
                    caps { floorspacemax 15000 plazaupgradetiles 2 }
                }
            }
            ;{
            ;    locname "board.xl.tall"
            ;    locdesc "board.xl.tall.desc"
            ;    def {
            ;        board { left -110 right 110 top 160 bottom -20 }
            ;        lot { left -90 right 90 top 80 bottom -20 floorspacecap 18000 }
            ;        caps { floorspacemax 30000 plazaupgradetiles 10 }
            ;    }
            ;}
        ]
        startup [
            {
                locname "newgame.option1"
                locdesc "newgame.option1.desc"
                startingMoney 20000
                startingEconomy 0.7
                difficulty easy
            }
            {
                locname "newgame.option2"
                locdesc "newgame.option2.desc"
                startingMoney 10000
                startingEconomy 0
                difficulty standard
            }
            {
                locname "newgame.option3"
                locdesc "newgame.option3.desc"
                startingMoney 5000
                startingEconomy 0
                difficulty harder
            }
            {
                locname "newgame.option4"
                locdesc "newgame.option4.desc"
                startingMoney 1500
                startingEconomy 0
                difficulty hard
            }
        ]
    }

    prestige {
        penaltydecay 0.2 ;; how much prestige penalty shrinks, per day

        populationcontrib {
            x [  0  20  40  60  80  100 130 165 205 250 300 350 410 480 560 650 750 850 950 1050 1150 ] ;; population size
            y [  0  1   2   3   4   5   6   7   8   9   10  11  12  13  14  15  16  17  18  19  20] ;; prestige level
        }
    }

    world {
        weather {
            dailyrainprobability 0.1
        }
        buildings {
            buildingwidth 11
            boundingbuildingdepth 100
            ; buildingsperlayer 6
            mindepth 200
            maxdepth 500
            ; depthinterval 50
            heightvariation 3
            depthperheight 50
            ; minseparation 7
            templates [
                {
                    groundfloor "backdrop-building-one-ground-floor"
                    secondfloor "backdrop-building-one-second-floor"
                    repeatfloor "backdrop-building-one-repeat-floor"
                    roof "backdrop-building-one-roof"
                    rooflayers "backdrop-building-one-roof-rear-layers"
                }
                {
                    groundfloor "backdrop-building-two-ground-floor"
                    secondfloor "backdrop-building-two-second-floor"
                    repeatfloor "backdrop-building-two-repeat-floor"
                    roof "backdrop-building-two-roof"
                    rooflayers "backdrop-building-two-roof-rear-layers"
                }
                {
                    groundfloor "backdrop-building-three-ground-floor"
                    secondfloor "backdrop-building-three-second-floor"
                    repeatfloor "backdrop-building-three-repeat-floor"
                    roof "backdrop-building-three-roof"
                    rooflayers "backdrop-building-three-roof-rear-layers"
                }
                {
                    groundfloor "backdrop-building-four-ground-floor"
                    secondfloor "backdrop-building-four-second-floor"
                    repeatfloor "backdrop-building-four-repeat-floor"
                    roof "backdrop-building-four-roof"
                    rooflayers "backdrop-building-four-roof-rear-layers"
                }
                {
                    groundfloor "backdrop-building-five-ground-floor"
                    secondfloor "backdrop-building-five-second-floor"
                    repeatfloor "backdrop-building-five-repeat-floor"
                    roof "backdrop-building-five-roof"
                    rooflayers "backdrop-building-five-roof-rear-layers"
                }
                {
                    groundfloor "backdrop-building-six-ground-floor"
                    secondfloor "backdrop-building-six-second-floor"
                    repeatfloor "backdrop-building-six-repeat-floor"
                    roof "backdrop-building-six-roof"
                    rooflayers "backdrop-building-six-roof-rear-layers"
                }
            ]
        }
    }

    currencies {
        favors {
            firstcost { value 10 }
            costmultiplier { value 1.25 }
        }

        buzz {
            firstcost { value 50 } ; mods [ { #type game-difficulty-modifier easymultiplier 0.5 hardmultiplier 2 } ] }
            costmultiplier { value 1.5 }

            lengthindays { value 1 }
            options [
                {   locname "goldenage.category.apartments"
                    imageindex 2
                    list [
                    {
                        id goldenage-apartments-satisfaction
                        locname "goldenage.apartments.satisfaction.title"
                        locdesc "goldenage.apartments.satisfaction.desc"
                        costmultiplier { value 1.0 }
                    }
                    {
                        id goldenage-apartments-utilities
                        locname "goldenage.apartments.utilities.title"
                        locdesc "goldenage.apartments.utilities.desc"
                        costmultiplier { value 1.2 }
                    }
                    {
                        id goldenage-apartments-waitlist
                        locname "goldenage.apartments.waitlist.title"
                        locdesc "goldenage.apartments.waitlist.desc"
                        costmultiplier { value 1.4 }
                    }
                    {
                        id goldenage-apartments-free
                        locname "goldenage.apartments.models.title"
                        locdesc "goldenage.apartments.models.desc"
                        costmultiplier { value 1.6 }
                    }
                    
                ] }
                {   locname "goldenage.category.infrastructure"
                    imageindex 3
                    list [
                     {
                        id goldenage-infrastucture-noopx
                        locname "goldenage.infrastructure.noopx.title"
                        locdesc "goldenage.infrastructure.noopx.desc"
                        costmultiplier { value 1.0 }
                     }
                     {
                        id goldenage-infrastucture-utilities
                        locname "goldenage.infrastructure.utilities.title"
                        locdesc "goldenage.infrastructure.utilities.desc"
                        costmultiplier { value 1.2 }
                     }
                     {
                        id goldenage-infrastucture-grime
                        locname "goldenage.infrastructure.grime.title"
                        locdesc "goldenage.infrastructure.grime.desc"
                        costmultiplier { value 1.4 }
                     }
                     {
                        id goldenage-infrastucture-freefloor
                        locname "goldenage.infrastructure.freefloor.title"
                        locdesc "goldenage.infrastructure.freefloor.desc"
                        costmultiplier { value 1.6 }
                     }
                ] }
                {   locname "goldenage.category.commercial"
                    imageindex 0
                    list [
                    {
                        id goldenage-commercial-profit
                        locname "goldenage.commercial.profit.title"
                        locdesc "goldenage.commercial.profit.desc"
                        costmultiplier { value 1.0 }
                    }
                    {
                        id goldenage-commercial-visitors
                        locname "goldenage.commercial.visitors.title"
                        locdesc "goldenage.commercial.visitors.desc"
                        costmultiplier { value 1.2 }
                    }
                    {
                        id goldenage-commercial-landscaping
                        locname "goldenage.commercial.landscaping.title"
                        locdesc "goldenage.commercial.landscaping.desc"
                        costmultiplier { value 1.4 }
                    }
                    {
                        id goldenage-commercial-feature
                        locname "goldenage.commercial.feature.title"
                        locdesc "goldenage.commercial.feature.desc"
                        costmultiplier { value 1.6 }
                    }
                ] }
                {   locname "goldenage.category.offices"
                    imageindex 1
                    list [
                    {
                        id goldenage-offices-satisfaction
                        locname "goldenage.offices.satisfaction.title"
                        locdesc "goldenage.offices.satisfaction.desc"
                        costmultiplier { value 1.0 }
                    }
                    {
                        id goldenage-offices-utilities
                        locname "goldenage.offices.utilities.title"
                        locdesc "goldenage.offices.utilities.desc"
                        costmultiplier { value 1.2 }
                    }
                    {
                        id goldenage-offices-promoted
                        locname "goldenage.offices.promoted.title"
                        locdesc "goldenage.offices.promoted.desc"
                        costmultiplier { value 1.4 }
                    }
                    {
                        id goldenage-offices-feature
                        locname "goldenage.offices.feature.title"
                        locdesc "goldenage.offices.feature.desc"
                        costmultiplier { value 1.6 }
                    }
                ] }
            ]
        }
    }

    notifs {
        entries [
            { type moveinoffice pulse #true } ;; layer deco ?
            { type moveinretail pulse #true } ;; layer deco ?
            { type moveinrestaurant pulse #true } ;; layer deco ?
            { type moveinapartment pulse #true } ;; layer deco ?
            { type moveinpending }
            { type unitupset }
            { type trashproblem }
            { type serviceoverloaded pulse #true }

            { type notenoughpower pulse #true }
            { type notenoughphone pulse #true }
            { type notenoughcable pulse #true }
            { type notenoughwater pulse #true }
            { type notenoughgas pulse #true }

            { type needconnpower pulse #true }
            { type needconnphone pulse #true }
            { type needconncable pulse #true }
            { type needconnwater pulse #true }
            { type needconngas pulse #true }
        ]
    }

    audio {
        musiczoomvolume {
            x [  0 150 250 700 1000 ]
            y [  0   0   1   1  0.5 ]
        }
        musictracks [
            ;; 0 doesn't exist
            { }

            ;; 1 rhodes
            {
                hourofday {
                    x [ 0 8 12 14 20 22 24 ] ;; play during night and early day only
                    y [ 1 1  1  0  0  1  1 ]
                }
                floorview { x [ 0 ] y [ 1 ] } ;; floor doesn't matter
            }

            ;; 2 drums
            {
                hourofday {
                    x [ 0 8 10 18 22 24 ] ;; play during the day
                    y [ 0 0  1  1  0  0 ]
                }
                floorview {
                    x [ -4 0 ]  ;; only play above ground
                    y [  0 1 ]
                }
            }

            ;; 3 rhytmic
            {
                hourofday {
                    x [ 0 6 8 18 20 24 ] ;; play during the day
                    y [ 0 0 1  1  0  0 ]
                }
                floorview {
                    x [ -4 0 ]  ;; only play above ground
                    y [  0 1 ]
                }
            }

            ;; 4 harmonics
            {
                hourofday {
                    x [ 0 ]
                    y [ 1 ]
                }
                floorview { x [ 0 ] y [ 1 ] } ;; floor doesn't matter
            }

            ;; 5 bass
            {
                hourofday {
                    x [ 0 ]
                    y [ 1 ]
                }
                floorview { x [ 0 ] y [ 1 ] } ;; floor doesn't matter
            }

            ;; 6 shaker
            {
                hourofday {
                    x [ 0 ]
                    y [ 1 ]
                }
                floorview {
                    x [ -4 0 ]  ;; only play above ground
                    y [  0 1 ]
                }
            }

            ;; 7 harp
            {
                hourofday {
                    x [ 0 14 16 20 22 24 ] ;; afternoon-evening
                    y [ 0  0  1  1  0  0 ]
                }
                floorview {
                    x [ -4 0 ]  ;; only play above ground
                    y [  0 1 ]
                }
            }

            ;; 8 pads
            {
                hourofday {
                    x [ 0 ]
                    y [ 1 ]
                }
                floorview { x [ 0 ] y [ 1 ] } ;; floor doesn't matter
            }
        ]
    }

    infra {
        overlayprefab "Pipe Overlay Background"
        pipes [
            {
                type utilwater
                prefabname "Pipe Util Water"
                dx 27 dy 74
                buildcost { value -10 mods [ 
                    { #type heatmap-modifier map floorHeatmap value -5 }
                    { #type golden-age-modifier id goldenage-infrastucture-utilities multiplier 0.5 } 
                 ] }
             }
            {
                type utilgas
                prefabname "Pipe Util Gas"
                dx 32 dy 63
                buildcost { value -13 mods [ 
                    { #type heatmap-modifier map floorHeatmap value -5 }
                    { #type golden-age-modifier id goldenage-apartments-utilities multiplier 0.5 } 
                ] }
            }

            {
                type utilpower
                prefabname "Pipe Util Power"
                dx 12 dy 107
                buildcost { value -10 mods [ 
                    { #type heatmap-modifier map floorHeatmap value -5 }
                    { #type golden-age-modifier id goldenage-infrastucture-utilities multiplier 0.5 } 
                ] }
            }
            {
                type utilphone
                prefabname "Pipe Util Phone"
                dx 17 dy 96
                buildcost { value -13 mods [ 
                    { #type heatmap-modifier map floorHeatmap value -5 } 
                    { #type golden-age-modifier id goldenage-offices-utilities multiplier 0.5 } 
                ] }
            }
            {
                type utilcable
                prefabname "Pipe Util Cable"
                dx 22 dy 85
                buildcost { value -13 mods [
                    { #type heatmap-modifier map floorHeatmap value -5 }
                    { #type game-difficulty-modifier harddelta -3 }
                    { #type golden-age-modifier id goldenage-apartments-utilities multiplier 0.5 } 
                ] }
            }
        ]
    }

    heatmaps {
        entries [
            {
                type "floorHeatmap"
                mulself 0
                addself 0
                mulx 0
                muly 0
                addx 0
                addy 0
                floorbonus 0.05
                floorbonusoffset -10
            }
            {
                type "elevatorHeatmap"
                mulself 0.7
                addself 0
                mulx 1
                muly 0
                addx -0.07
                addy 0
                placementrefresh 10
            }
            {
                type "satisfactionHeatmap"
                mulself 1
                addself -0.1
            }
            {
                type "profitabilityHeatmap"
                mulself 1
                addself -0.1
            }
            {
                type "uglinessHeatmap"
                mulself 0.7
                addself 0
                mulx 1
                muly 0
                addx -0.1
                addy 0
            }
            {
                type "prettinessHeatmap"
                mulself 0.7
                addself 0
                mulx 1
                muly 1
                addx -0.05
                addy -0.5
            }
            {
                type "aestheticsHeatmap"
                update special
            }
            {
                type "trafficHeatmap" ;; yesterday's
                update none
            }
            {
                type "trafficTodayHeatmap" ;; today's (cumulative)
                update none
                dailycopyto "trafficHeatmap"
            }
            {
                type "noiseHeatmap"
                mulself 0.7
                mulx 1
                muly 0.8
                addx -0.05
                addy -0.2
                positive #false
            }
            {
                type "smellHeatmap"
                mulself 0.7
                mulx 1
                muly 0.9
                addx -0.1
                addy -0.4
                positive #false
            }
            {
                type "grimeHeatmap"
                mulself 1
                addself -0.1
            }
            {
                type "trashHeatmap"
                mulself 1
                addself -0.1
            }
        ]
    }

    economy {
        startingHour  10
        renovateTileCost { value -30 mods [ 
            { #type game-difficulty-modifier harddelta 5 easymultiplier 0.5  }
            { #type golden-age-modifier id goldenage-infrastucture-grime multiplier 0.5 } 
        ] }

        broomClosetGrimeDelta { value -0.05 }
        econMaxChangePerDay { value 0.1 }
        econCheckDelayDays { value 5 }

        maxactiveloans { value 2 mods [ { #type golden-age-modifier id goldenage-offices-feature multiplier 1.5 } ] }
        loans [ 
            {
                locname "loans.cc.name"
                locmouseover "loans.cc.mo"
                loanamt { value 2500 mods [ { #type game-difficulty-modifier harddelta -1000 }  ] }
                days { value 20 mods [ ] }
                paymentamt { value -150 mods [ { #type game-difficulty-modifier harddelta 60 } ] }
                imageindex 0
                reqs [
                    { #type scenario-requirement tags [ "scenario-7" ] result fail }
                ]
            }
            {
                locname "loans.sb.name"
                locmouseover "loans.sb.mo"
                loanamt { value 5000 mods [ { #type game-difficulty-modifier harddelta -3000 } ] }
                days { value 20 }
                paymentamt { value -300 mods [ { #type game-difficulty-modifier harddelta 175 } ] }
                imageindex 1
                reqs [ 
                    { #type scenario-requirement tags [ "scenario-7" ] result fail }
                ]
            }
            {
                locname "loans.cb.name"
                locmouseover "loans.cb.mo"
                loanamt { value 10000 mods [ { #type game-difficulty-modifier harddelta -5000 } ] }
                days { value 30 }
                paymentamt { value -400 mods [ { #type game-difficulty-modifier harddelta 200 } ] }
                imageindex 2
                reqs [ 
                    { #type prestige-requirement value 2 } 
                    { #type scenario-requirement tags [ "scenario-7" ] result fail }
                ]
            }
            {
                locname "loans.pe.name"
                locmouseover "loans.pe.mo"
                loanamt { value 15000 mods [ { #type game-difficulty-modifier harddelta -5000  } ] }
                days { value 30 }
                paymentamt { value -600 mods [ { #type game-difficulty-modifier harddelta 200 } ] }
                imageindex 3
                reqs [ 
                    { #type prestige-requirement value 5 } 
                    { #type scenario-requirement tags [ "scenario-7" ] result fail }
                ]
            }
            {
                locname "loans.af.name"
                locmouseover "loans.af.mo"
                loanamt { value 20000 mods [ { #type game-difficulty-modifier harddelta -5000 } ] }
                days { value 30 }
                paymentamt { value -825 mods [ { #type game-difficulty-modifier harddelta 225 } ] }
                imageindex 3
                reqs [ 
                    { #type prestige-requirement value 10 } 
                    { #type scenario-requirement tags [ "scenario-7" ] result fail }
                ]
            }
            {
                locname "loans.scenario-7.name"
                locmouseover "loans.scenario-7.mo"
                loanamt { value 5000 }
                days { value 14 }
                paymentamt { value -400 }
                imageindex 0
                visreqs [ 
                    { #type scenario-requirement tags [ "scenario-7" ] result pass }
                ]
                reqs [
                    { #type scenario-requirement tags [ "scenario-7" ] result pass }
                ]
            }
        ]

        moveins [
        {
            id "office-4-1"
            type office
            size { x 4 y 1 }
            waithours { value 2 mods [ 
                { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 }
                { #type game-difficulty-modifier harddelta 2 } 
            ] }
            dailyaddprobability { value 0.3 mods [ 
                { #type economy-modifier multiplier 0.2 rounding 0.01 }
                { #type scenario-modifier tags [ "scenario-3"] when pass multiplier 1.5 }
                { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 }
                { #type game-difficulty-modifier hardmultiplier 0.5 easymultiplier 1.5 } 
            ] }
            minresults { value 2 mods [ 
                { #type game-difficulty-modifier harddelta -1 easydelta 1 }
                { #type golden-age-modifier id goldenage-offices-promoted multiplier 2 }
                { #type scenario-modifier tags [ "scenario-3"] when pass multiplier 1.5 }
                { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
            ] }
            maxresults { value 5 mods [ 
                { #type game-difficulty-modifier harddelta -2 }
                { #type economy-modifier multiplier 1 rounding 0.1 }
                { #type golden-age-modifier id goldenage-offices-promoted multiplier 1.5 }
                { #type scenario-modifier tags [ "scenario-3"] when pass multiplier 1.5 }
            ] }
            entries [
                {
                    id "office-4-ins"
                    locname "moveins.office.insurance-1"
                    tags [ insurance ]
                    cost { value -50 mods [   ] }
                    reqs [
                        { #type scenario-requirement tags [ "scenario-3" ] result fail }
                        { #type scenario-requirement tags [ "scenario-13" ] result fail }
                    ]
                }
                {
                    id "office-4-acc"
                    locname "moveins.office.accounting-1"
                    tags [ accounting ]
                    cost { value -75 mods [   ] }
                    reqs [
                        { #type tutorial-done-requirement }
                        { #type scenario-requirement tags [ "scenario-13" ] result fail }
                    ]
                }
                {
                    id "office-4-leg"
                    locname "moveins.office.legal-1"
                    tags [ legal ]
                    cost { value -100 mods [ { #type game-difficulty-modifier harddelta 25 } ] }
                    reqs [
                        { #type tutorial-done-requirement }
                        { #type score-requirement name score-restaurant-small minscore 1 }
                        { #type scenario-requirement tags [ "scenario-13" ] result fail }
                    ]
                }
                {
                    id "office-4-des"
                    locname "moveins.office.design-1"
                    tags [ design ]
                    cost { value -100 mods [  ] }
                    reqs [
                        { #type tutorial-done-requirement }
                        { #type score-requirement name score-restaurant-cafe minscore 1 }
                        { #type prestige-requirement value 1 }
                        { #type scenario-requirement tags [ "scenario-3" ] result fail }
                    ]
                }
            ]
        }
        {
            id "office-10-1"
            type office
            size { x 10 y 1 }
            waithours { value 4 mods [ 
                { #type game-difficulty-modifier harddelta 2 }
                { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
            ] }
            dailyaddprobability { value 0.3 mods [ 
                { #type economy-modifier multiplier 0.2 rounding 0.01 }
                { #type game-difficulty-modifier hardmultiplier 0.5 easymultiplier 1.5 }
                { #type scenario-modifier tags [ "scenario-3"] when pass multiplier 1.5 }
                { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
            ] }
            minresults { value 2 mods [ 
                { #type game-difficulty-modifier harddelta -1 easydelta 1 }
                { #type golden-age-modifier id goldenage-offices-promoted multiplier 3 }
                { #type scenario-modifier tags [ "scenario-3"] when pass multiplier 1.5 }
                { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
            ] }
            maxresults { value 3 mods [ 
                { #type economy-modifier multiplier 1 rounding 0.1 }
                { #type game-difficulty-modifier harddelta -1 easydelta 2 }
                { #type golden-age-modifier id goldenage-offices-promoted multiplier 2 }
                { #type scenario-modifier tags [ "scenario-3"] when pass multiplier 1.5 }
            ] }
            entries [
                {
                    id "office-10-med"
                    locname "moveins.office.medical-2"
                    tags [ medical ]
                    cost { value -125 mods [ { #type game-difficulty-modifier harddelta -25 } ] }
                    reqs [
                        { #type entity-count-requirement type atleast count 1 template retail-level-one-d }
                        { #type prestige-requirement value 2 }
                        { #type scenario-requirement tags [ "scenario-13" ] result fail }
                    ]
                }
                {
                    id "office-10-des"
                    locname "moveins.office.design-2"
                    tags [ design ]
                    cost { value -125 mods [ { #type game-difficulty-modifier harddelta -25 } ] }
                    reqs [
                        { #type scenario-requirement tags [ "scenario-3" ] result fail }
                        { #type prestige-requirement value 2 }
                    ]
                }
                {
                    id "office-10-leg"
                    locname "moveins.office.legal-2"
                    tags [ legal ]
                    cost { value -125 mods [ { #type game-difficulty-modifier harddelta -25 } ] }
                    reqs [
                        { #type prestige-requirement value 2 }
                        { #type scenario-requirement tags [ "scenario-13" ] result fail }
                    ]
                }
                {
                    id "office-10-fin"
                    locname "moveins.office.finance-2"
                    tags [ finance ]
                    cost { value -125 mods [ { #type game-difficulty-modifier harddelta -25 } ] }
                    reqs [
                        { #type prestige-requirement value 3 }
                        { #type scenario-requirement tags [ "scenario-13" ] result fail }
                    ]
                }
            ]
        }
        {
            id "office-15-1"
            type office
            size { x 15 y 1 }
            waithours { value 12 mods [ 
                { #type game-difficulty-modifier easydelta -2 }
                { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
            ] }
            dailyaddprobability { value 0.3 mods [ 
                { #type economy-modifier multiplier 0.2 rounding 0.01 }
                { #type game-difficulty-modifier hardmultiplier 0.5 easymultiplier 1.5 }
                { #type scenario-modifier tags [ "scenario-3"] when pass multiplier 1.5 }
                { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
            ] }
            minresults { value 1 mods [ 
                { #type golden-age-modifier id goldenage-offices-promoted multiplier 3 }
                { #type scenario-modifier tags [ "scenario-3"] when pass multiplier 1.5 }
            ] }
            maxresults { value 2 mods [ 
                { #type economy-modifier multiplier 1 rounding 0.1 }
                { #type golden-age-modifier id goldenage-offices-promoted multiplier 2 }
                { #type scenario-modifier tags [ "scenario-3"] when pass multiplier 1.5 }
            ] }
            entries [
                {
                    id "office-15-fin"
                    locname "moveins.office.finance-3"
                    tags [ finance ]
                    cost { value -300 mods [ { #type game-difficulty-modifier harddelta -100 } ] }
                    reqs [
                        { #type prestige-requirement value 9 }
                        { #type scenario-requirement tags [ "scenario-13" ] result fail }
                    ]
                }
                {
                    id "office-15-eng"
                    locname "moveins.office.engineers-3"
                    tags [ engineering ]
                    cost { value -300 mods [ { #type game-difficulty-modifier harddelta -100 } ] }
                    reqs [
                        { #type prestige-requirement value 9 }
                        { #type scenario-requirement tags [ "scenario-3" ] result fail }
                    ]
                }
                {
                    id "office-15-mar"
                    locname "moveins.office.marketing-3"
                    tags [ marketing ]
                    cost { value -300 mods [ { #type game-difficulty-modifier harddelta -100 } ] }
                    reqs [
                        { #type prestige-requirement value 9 }
                        { #type scenario-requirement tags [ "scenario-13" ] result fail }
                    ]
                }
                {
                    id "office-15-tech"
                    locname "moveins.office.tech-3"
                    tags [ tech ]
                    cost { value -300 mods [ { #type game-difficulty-modifier harddelta -100 } ] }
                    reqs [
                        { #type prestige-requirement value 10 }
                        { #type scenario-requirement tags [ "scenario-3" ] result fail }
                    ]
                }
                {
                    id "office-15-med"
                    locname "moveins.office.medical-3"
                    tags [ medical ]
                    cost { value -300 mods [ { #type game-difficulty-modifier harddelta -100 } ] }
                    reqs [
                        { #type prestige-requirement value 10 }
                        { #type scenario-requirement tags [ "scenario-13" ] result fail }
                    ]
                }
            ]
        }
        {
            id "office-10-2"
            type office
            size { x 10 y 2 }
            waithours { value 24 mods [ { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } ] }
            dailyaddprobability { value 0.3 mods [ 
                { #type economy-modifier multiplier 0.2 rounding 0.01 }
                { #type game-difficulty-modifier hardmultiplier 0.5 easymultiplier 1.5 }
                { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
            ] }
            minresults { value 1 mods [ 
                { #type golden-age-modifier id goldenage-offices-promoted multiplier 3 }
            ] }
            maxresults { value 2 mods [ 
                { #type economy-modifier multiplier 1 rounding 0.1 }
                { #type golden-age-modifier id goldenage-offices-promoted multiplier 2 }
            ] }
            entries [
                {
                    id "office-hq-tech"
                    locname "moveins.office.tech-4"
                    tags [ tech-four ]
                    cost { value -5000 mods [ { #type game-difficulty-modifier easymultiplier 0.5 } ] }
                    reqs [
                        { #type prestige-requirement value 14 }
                        { #type scenario-requirement tags [ "scenario-3" ] result fail }
                    ]
                }
                {
                    id "office-hq-media"
                    locname "moveins.office.media-4"
                    tags [ creative-four ]
                    cost { value -5000 mods [ { #type game-difficulty-modifier easymultiplier 0.5 } ] }
                    reqs [
                        { #type prestige-requirement value 14 }
                        { #type scenario-requirement tags [ "scenario-3" ] result fail }
                        { #type scenario-requirement tags [ "scenario-13" ] result fail }
                    ]
                }
                {
                    id "office-hq-government"
                    locname "moveins.office.govenment-4"
                    tags [ government-office ]
                    cost { value -5000 mods [ { #type game-difficulty-modifier easymultiplier 0.5 } ] }
                    reqs [
                        { #type prestige-requirement value 14 }
                        { #type scenario-requirement tags [ "scenario-13" ] result fail }
                    ]
                }
                {
                    id "office-hq-finance"
                    locname "moveins.office.finance-4"
                    tags [ finacial-four ]
                    cost { value -5000 mods [ { #type game-difficulty-modifier easymultiplier 0.5 } ] }
                    reqs [
                        { #type prestige-requirement value 14 }
                        { #type scenario-requirement tags [ "scenario-13" ] result fail }
                    ]
                }
            ]

        }
        {
            id "restaurant-4-1"
            type restaurant
            size { x 4 y 1 }
            waithours { value 2 mods [ 
                { #type game-difficulty-modifier harddelta 2 }
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 0.5 }
                { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
            ] }
            dailyaddprobability { value 0.3 mods [ 
                { #type economy-modifier multiplier 0.2 rounding 0.01 }
                { #type game-difficulty-modifier hardmultiplier 0.5 easymultiplier 1.5 }
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 2 }
                { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 }
                { #type scenario-modifier tags [ "scenario-8"] when pass multiplier 2 } 
            ] }
            minresults { value 1 mods [ 
                { #type game-difficulty-modifier easydelta 1 }
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 3 }
                { #type scenario-modifier tags [ "scenario-8"] when pass multiplier 2 } 
            ] }
            maxresults { value 3 mods [ 
                { #type economy-modifier multiplier 1 rounding 0.1 }
                { #type game-difficulty-modifier harddelta -1 }
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 2 }
                { #type scenario-modifier tags [ "scenario-8"] when pass multiplier 2 } 
            ] }
            entries [
                {
                    id "restaurant-4-foodcourt"
                    locname "moveins.commercial.restaurant-foodcourt"
                    tags [ foodcourt ]
                    cost { value -100 mods [ 
                        { #type game-difficulty-modifier harddelta 25 } 
                        { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }
                }
                {
                    id "restaurant-4-cafe"
                    locname "moveins.commercial.restaurant-cafe"
                    tags [ cafe ]
                    cost { value -125 mods [ 
                        { #type game-difficulty-modifier harddelta 50 }
                        { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }
                    reqs [ 
                        { #type tutorial-done-requirement }
                        { #type prestige-requirement value 1 } 
                    ]
                }
            ]
        }
        {
            id "retail-7-1"
            type retail
            size { x 7 y 1 }
            waithours { value 2 mods [ 
                { #type game-difficulty-modifier harddelta 2 }
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 0.5 }
                { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
            ] }
            dailyaddprobability { value 0.3 mods [ 
                { #type economy-modifier multiplier 0.2 rounding 0.01 }
                { #type game-difficulty-modifier hardmultiplier 0.5 easymultiplier 1.5 }
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 2 }
                { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 }
                { #type scenario-modifier tags [ "scenario-8"] when pass multiplier 2 } 
            ] }
            minresults { value 1 mods [ 
                { #type game-difficulty-modifier easydelta 1 }
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 3 }
                { #type scenario-modifier tags [ "scenario-8"] when pass multiplier 2 } 
            ] }
            maxresults { value 3 mods [ 
                { #type economy-modifier multiplier 1 rounding 0.1 }
                { #type game-difficulty-modifier harddelta -1 }
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 2 }
                { #type scenario-modifier tags [ "scenario-8"] when pass multiplier 2 } 
            ] }
            entries [
                {
                    id "retail-7-food"
                    locname "moveins.commercial.retail-food"
                    tags [ food ]
                    cost { value -150 mods [ 
                        { #type game-difficulty-modifier hardmultiplier 2 }                    
                        { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }
                    reqs [
                    ]
                }
                {
                    id "retail-7-elec"
                    locname "moveins.commercial.retail-elec"
                    tags [ electronics ]
                    cost { value -150 mods [ 
                        { #type game-difficulty-modifier hardmultiplier 2 }
                        { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }
                    reqs [
                    ]
                }
                {
                    id "retail-7-books"
                    locname "moveins.commercial.retail-books"
                    tags [ books ]
                    cost { value -150 mods [ 
                        { #type game-difficulty-modifier hardmultiplier 2 }
                        { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }
                    reqs [
                    ]
                }
                {
                    id "retail-7-health"
                    locname "moveins.commercial.retail-health"
                    tags [ health ]
                    cost { value -150 mods [ 
                        { #type game-difficulty-modifier hardmultiplier 2 }
                        { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }
                    reqs [
                    ]
                }
                 {
                    id "retail-7-decor"
                    locname "moveins.commercial.retail-decor"
                    tags [ decor ]
                    cost { value -150 mods [ 
                        { #type game-difficulty-modifier hardmultiplier 2 }
                        { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }
                    reqs [
                    ]
                }
                {
                    id "retail-7-bottles"
                    locname "moveins.commercial.retail-bottles"
                    tags [ drink ]
                    cost { value -150 mods [ 
                        { #type game-difficulty-modifier hardmultiplier 2 }
                        { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }
                    reqs [
                    ]
                }
            ]
        }
        {
            id "restaurant-8-1"
            type restaurant
            size { x 8 y 1 }
            waithours { value 5 mods [ 
                { #type game-difficulty-modifier harddelta 2 easydelta -1 }
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 0.5 }
                { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
            ] }
            dailyaddprobability { value 0.3 mods [ 
                { #type economy-modifier multiplier 0.2 rounding 0.01 }
                { #type game-difficulty-modifier hardmultiplier 0.5 easymultiplier 1.5 }
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 2 }
                { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 }
                { #type scenario-modifier tags [ "scenario-8"] when pass multiplier 2 } 
            ] }
            minresults { value 1 mods [ 
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 3 }
                { #type scenario-modifier tags [ "scenario-8"] when pass multiplier 2 } 
            ] }
            maxresults { value 3 mods [ 
                { #type economy-modifier multiplier 1 rounding 0.1 }
                { #type game-difficulty-modifier harddelta -1 }
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 2 }
                { #type scenario-modifier tags [ "scenario-8"] when pass multiplier 2 } 
            ] }
            entries [
                {
                    id "restaurant-8-fast"
                    locname "moveins.commercial.restuarant-fastfood"
                    tags [ fastfood ]
                    cost { value -200 mods [ 
                       { #type game-difficulty-modifier hardmultiplier 2 } 
                       { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }
                    reqs [
                        { #type prestige-requirement value 3 }
                    ]
                }
                {
                    id "restaurant-8-diner"
                    locname "moveins.commercial.restaurant-diner"
                    tags [ diner ]
                    cost { value -200 mods [ 
                       { #type game-difficulty-modifier hardmultiplier 2 } 
                       { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }
                    reqs [
                        { #type prestige-requirement value 3 }
                    ]
                }
                {
                    id "restaurant-8-sandwiches"
                    locname "moveins.commercial.restaurant-8-sandwiches"
                    tags [ sandwich ]
                    cost { value -200 mods [ 
                       { #type game-difficulty-modifier hardmultiplier 2 } 
                       { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }
                    reqs [
                        { #type prestige-requirement value 3 }
                    ]
                }
                {
                    id "restaurant-8-foodcourt"
                    locname "moveins.commercial.restaurant-hotbar"
                    tags [ foodcourt ]
                    cost { value -200 mods [ 
                       { #type game-difficulty-modifier hardmultiplier 2 } 
                       { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }
                    reqs [
                        { #type prestige-requirement value 3 }
                    ]
                }
                 {
                    id "restaurant-8-pizza"
                    locname "moveins.commercial.restaurant-pizza"
                    tags [ pizza ]
                    cost { value -200 mods [ 
                       { #type game-difficulty-modifier hardmultiplier 2 } 
                       { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }
                    reqs [
                        { #type prestige-requirement value 3 }
                    ]
                }
            ]
        }
        {
            id "retail-12-1"
            type retail
            size { x 12 y 1 }
            waithours { value 6 mods [ 
                { #type game-difficulty-modifier harddelta 2 easydelta -1 }
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 0.5 }
                { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
            ] }
			dailyaddprobability { value 0.3 mods [ 
                { #type economy-modifier multiplier 0.2 rounding 0.01 }
                { #type game-difficulty-modifier hardmultiplier 0.5 easymultiplier 1.5 }
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 2 }
                { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 }
                { #type scenario-modifier tags [ "scenario-8"] when pass multiplier 2 } 
            ] }
            minresults { value 1 mods [ 
                { #type game-difficulty-modifier easydelta 1 }
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 3 }
                { #type scenario-modifier tags [ "scenario-8"] when pass multiplier 2 } 
            ] } 
            maxresults { value 2 mods [ 
                { #type economy-modifier multiplier 1 rounding 0.1 }
                { #type game-difficulty-modifier harddelta -1 easydelta 1 }
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 2 }
                { #type scenario-modifier tags [ "scenario-8"] when pass multiplier 2 } 
            ] }
            entries [
                {
                    id "retail-12-clothes"
                    locname "moveins.commercial.retail2-clothes"
                    tags [ clothing ]
                    cost { value -200 mods [ 
                       { #type game-difficulty-modifier hardmultiplier 2 } 
                       { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }
                    reqs [
                        { #type prestige-requirement value 5 }
                    ]
                }
                {
                    id "retail-12-elec"
                    locname "moveins.commercial.retail2-elec"
                    tags [ electronics ]
                    cost { value -200 mods [ 
                       { #type game-difficulty-modifier hardmultiplier 2 } 
                       { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }
                    reqs [
                        { #type prestige-requirement value 5 }
                    ]
                }
                {
                    id "retail-12-shoes"
                    locname "moveins.commercial.retail2-shoes"
                    tags [ shoes ]
                    cost { value -200 mods [ 
                       { #type game-difficulty-modifier hardmultiplier 2 } 
                       { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }
                    reqs [
                        { #type prestige-requirement value 5 }
                    ]
                }
                {
                    id "retail-12-bags"
                    locname "moveins.commercial.retail2-handbags"
                    tags [ handbags ]
                    cost { value -200 mods [ 
                       { #type game-difficulty-modifier hardmultiplier 2 } 
                       { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }
                    reqs [
                        { #type prestige-requirement value 5 }
                    ]
                }
                {
                    id "retail-12-house"
                    locname "moveins.commercial.retail2-housewares"
                    tags [ housewares ]
                    cost { value -200 mods [ 
                       { #type game-difficulty-modifier hardmultiplier 2 } 
                       { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }
                    reqs [
                        { #type prestige-requirement value 5 }
                    ]
                }
            ]
        }
        {
            id "retail-12-2"
            type retail
            size { x 12 y 2 }
            waithours { value 10 mods [ 
                { #type game-difficulty-modifier harddelta 5 easydelta -2 }
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 0.5 }
                { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
            ] }
            dailyaddprobability { value 0.3 mods [ 
                { #type economy-modifier multiplier 0.2 rounding 0.01 }
                { #type game-difficulty-modifier hardmultiplier 0.5 easymultiplier 1.5 }
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 2 }
                { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 }
                { #type scenario-modifier tags [ "scenario-8"] when pass multiplier 2 } 
            ] }
            minresults { value 1 mods [ 
                { #type game-difficulty-modifier easydelta 1 }
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 3 }
                { #type scenario-modifier tags [ "scenario-8"] when pass multiplier 2 } 
            ] } 
            maxresults { value 2 mods [ 
                { #type economy-modifier multiplier 1 rounding 0.1 }
                { #type game-difficulty-modifier easydelta 1 }
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 2 }
                { #type scenario-modifier tags [ "scenario-8"] when pass multiplier 2 } 
            ] } 
            entries [
                {
                    id "retail-12x2-departmentstore"
                    locname "moviens.commercial.retail3.departmentstore"
                    tags [ departmentstore ]
                    cost { value -500 mods [ 
                        { #type game-difficulty-modifier hardmultiplier 2 } 
                        { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }
                    reqs [
                        { #type prestige-requirement value 10 }
                    ]
                }
                {
                    id "retail-12x2-housewares"
                    locname "moviens.commercial.retail3.housewares"
                    tags [ housewares ]
                    cost { value -500 mods [ 
                        { #type game-difficulty-modifier hardmultiplier 2 } 
                        { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }                    
                    reqs [
                        { #type prestige-requirement value 10 }
                    ]
                }
                {
                    id "retail-12x2-electronics"
                    locname "moviens.commercial.retail3.electronics"
                    tags [ electronics ]
                    cost { value -500 mods [ 
                        { #type game-difficulty-modifier hardmultiplier 2 } 
                        { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }                    
                    reqs [
                        { #type prestige-requirement value 10 }
                    ]
                }
                {
                    id "retail-12x2-grocerystore"
                    locname "moviens.commercial.retail3.food"
                    tags [ food ]
                    cost { value -500 mods [ 
                        { #type game-difficulty-modifier hardmultiplier 2 } 
                        { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }                    
                    reqs [
                        { #type prestige-requirement value 10 }
                    ]
                }

            ]
        }
        {
            id "retail-8-1"
            type retail
            size { x 8 y 1 }
            waithours { value 24 mods [ 
                { #type game-difficulty-modifier easydelta -6 }
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 0.5 }
                { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
            ] }
            dailyaddprobability { value 0.3 mods [ 
                { #type economy-modifier multiplier 0.2 rounding 0.01 }
                { #type game-difficulty-modifier hardmultiplier 0.5 easymultiplier 1.5 }
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 2 }
                { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 }
                { #type scenario-modifier tags [ "scenario-8"] when pass multiplier 2 } 
            ] }
            minresults { value 1 mods [ 
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 3 }
                { #type scenario-modifier tags [ "scenario-8"] when pass multiplier 2 } 
            ] } 
            maxresults { value 2 mods [ 
                { #type economy-modifier multiplier 1 rounding 0.1 }
                { #type game-difficulty-modifier easydelta 1 }
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 2 }
                { #type scenario-modifier tags [ "scenario-8"] when pass multiplier 2 } 
            ] } 
            entries [
                {
                    id "retail-four-china"
                    locname "moveins.commercial.retail4.china"
                    tags [ retail-four-a ]
                    cost { value -2500 mods [ 
                        { #type game-difficulty-modifier hardmultiplier 2 easymultiplier 0.5 } 
                        { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }
                    reqs [
                        { #type prestige-requirement value 14 }
                        { #type golden-ages id goldenage-commercial-visitors }
                    ]
                }
                {
                    id "retail-four-cosmetics"
                    locname "moveins.commercial.retail4.cosmetics"
                    tags [ retail-four-b ]
                    cost { value -2500 mods [ 
                        { #type game-difficulty-modifier hardmultiplier 2 easymultiplier 0.5 } 
                        { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }
                    reqs [
                        { #type prestige-requirement value 14 }
                        { #type golden-ages id goldenage-commercial-visitors }
                    ]
                }
                {
                    id "retail-four-jewelry"
                    locname "moveins.commercial.retail4.jewelry"
                    tags [ retail-four-c ]
                    cost { value -2500 mods [ 
                        { #type game-difficulty-modifier hardmultiplier 2 easymultiplier 0.5 } 
                        { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }
                    reqs [
                        { #type prestige-requirement value 14 }
                        { #type golden-ages id goldenage-commercial-visitors }
                    ]
                }
                {
                    id "retail-four-art"
                    locname "moveins.commercial.retail4.art"
                    tags [ retail-four-d ]
                    cost { value -2500 mods [ 
                        { #type game-difficulty-modifier hardmultiplier 2 easymultiplier 0.5 } 
                        { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }
                    reqs [
                        { #type prestige-requirement value 15 }
                        { #type golden-ages id goldenage-commercial-visitors }
                    ]
                }
                {
                    id "retail-four-rarebooks"
                    locname "moveins.commercial.retail4.rarebooks"
                    tags [ retail-four-e ]
                    cost { value -2500 mods [ 
                        { #type game-difficulty-modifier hardmultiplier 2 easymultiplier 0.5 } 
                        { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }
                    reqs [
                        { #type prestige-requirement value 15 }
                        { #type golden-ages id goldenage-commercial-visitors }
                    ]
                }
                {
                    id "retail-four-wine"
                    locname "moveins.commercial.retail4.wine"
                    tags [ retail-four-f ]
                    cost { value -2500 mods [ 
                        { #type game-difficulty-modifier hardmultiplier 2 easymultiplier 0.5 } 
                        { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }
                    reqs [
                        { #type prestige-requirement value 14 }
                        { #type golden-ages id goldenage-commercial-visitors }
                    ]
                }
            ]
        }
        {
            id "restaurant-16-1"
            type restaurant
            size { x 16 y 1 }
            waithours { value 8 mods [ 
                { #type game-difficulty-modifier harddelta 4 easydelta -2 }
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 0.5 }
                { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
            ] }
            dailyaddprobability { value 0.2 mods [ 
                { #type economy-modifier multiplier 0.2 rounding 0.01 }
                { #type game-difficulty-modifier hardmultiplier 0.5 easymultiplier 1.5 }
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 2 }
                { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 }
                { #type scenario-modifier tags [ "scenario-8"] when pass multiplier 2 } 
            ] }
            minresults { value 1 mods [ 
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 3 }
                { #type scenario-modifier tags [ "scenario-8"] when pass multiplier 2 } 
            ] } 
            maxresults { value 2 mods [ 
                { #type economy-modifier multiplier 1 rounding 0.1 }
                { #type game-difficulty-modifier easydelta 1 }
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 2 }
                { #type scenario-modifier tags [ "scenario-8"] when pass multiplier 2 } 
            ] } 
            entries [
                {
                    id "restaurant-three-sportsbar"
                    locname "moveins.commercial.restaurant-sportsbar"
                    tags [ sportsbar ]
                    cost { value -1000 mods [ 
                        { #type game-difficulty-modifier hardmultiplier 1.5 easymultiplier 0.5 } 
                        { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }
                    reqs [
                        { #type prestige-requirement value 7 }
                    ]
                }
                {
                    id "restaurant-three-italian"
                    locname "moveins.commercial.restaurant-italian"
                    tags [ italian ]
                    cost { value -1000 mods [ 
                        { #type game-difficulty-modifier hardmultiplier 1.5 easymultiplier 0.5 } 
                        { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }
                    reqs [
                        { #type prestige-requirement value 7 }
                    ]
                }
                {
                    id "restaurant-three-mexican"
                    locname "moveins.commercial.restaurant-mexican"
                    tags [ mexican ]
                    cost { value -1000 mods [ 
                        { #type game-difficulty-modifier hardmultiplier 1.5 easymultiplier 0.5 } 
                        { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }
                    reqs [
                        { #type prestige-requirement value 7 }
                    ]
                }
                {
                    id "restaurant-three-brunch"
                    locname "moveins.commercial.restaurant-brunch"
                    tags [ brunch ]
                    cost { value -1000 mods [ 
                        { #type game-difficulty-modifier hardmultiplier 1.5 easymultiplier 0.5 } 
                        { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }
                    reqs [
                        { #type prestige-requirement value 7 }
                    ]
                }
                {
                    id "restaurant-three-family"
                    locname "moveins.commercial.restaurant-family"
                    tags [ family ]
                    cost { value -1000 mods [ 
                        { #type game-difficulty-modifier hardmultiplier 1.5 easymultiplier 0.5 } 
                        { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }
                    reqs [
                        { #type prestige-requirement value 7 }
                    ]
                }
            ]
        }
        {
            id "restaurant-14-1"
            type restaurant
            size { x 14 y 1 }
            waithours { value 24 mods [ 
                { #type game-difficulty-modifier easydelta -6  }
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 0.5 }
                { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
            ] }
            dailyaddprobability { value 0.2 mods [ 
                { #type economy-modifier multiplier 0.2 rounding 0.01 }
                { #type game-difficulty-modifier hardmultiplier 0.5 easymultiplier 1.5 }
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 2 }
                { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 }
                { #type scenario-modifier tags [ "scenario-8"] when pass multiplier 2 } 
            ] }
            minresults { value 1 mods [ 
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 3 }
                { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 }
                { #type scenario-modifier tags [ "scenario-8"] when pass multiplier 2 } 
            ] } 
            maxresults { value 2 mods [ 
                { #type economy-modifier multiplier 1 rounding 0.1 }
                { #type game-difficulty-modifier easydelta 1 }
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 2 }
                { #type scenario-modifier tags [ "scenario-8"] when pass multiplier 2 } 
            ] } 
            entries [
                {
                    id "rest-four-chinese"
                    locname "moveins.commercial.restaurant.chinese"
                    tags [ chinese ]
                    cost { value -2500 mods [ 
                        { #type game-difficulty-modifier hardmultiplier 1.5 easymultiplier 0.5 }
                        { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }
                    reqs [
                        { #type prestige-requirement value 13 sathit -0.2 }
                    ]
                }
                {
                    id "rest-four-indian"
                    locname "moveins.commercial.restaurant.indian"
                    tags [ indian ]
                    cost { value -2500 mods [ 
                        { #type game-difficulty-modifier hardmultiplier 1.5 easymultiplier 0.5 }
                        { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }
                     reqs [
                        { #type prestige-requirement value 13 sathit -0.2 }
                    ]
                }
                {
                    id "rest-four-seafood"
                    locname "moveins.commercial.restaurant.seafood"
                    tags [ seafood ]
                    cost { value -2500 mods [ 
                        { #type game-difficulty-modifier hardmultiplier 1.5 easymultiplier 0.5 }
                        { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }
                     reqs [
                        { #type prestige-requirement value 13 sathit -0.2 }
                    ]
                }
                {
                    id "rest-four-thai"
                    locname "moveins.commercial.restaurant.thai"
                    tags [ thai ]
                    cost { value -2500 mods [ 
                        { #type game-difficulty-modifier hardmultiplier 1.5 easymultiplier 0.5 }
                        { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }
                     reqs [
                        { #type prestige-requirement value 13 sathit -0.2 }
                    ]
                }
                {
                    id "rest-four-japanese"
                    locname "moveins.commercial.restaurant.japanese"
                    tags [ japanese ]
                    cost { value -2500 mods [ 
                        { #type game-difficulty-modifier hardmultiplier 1.5 easymultiplier 0.5 }
                        { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }
                     reqs [
                        { #type prestige-requirement value 14 sathit -0.2 }
                    ]
                }
                {
                    id "rest-four-french"
                    locname "moveins.commercial.restaurant.french"
                    tags [ french ]
                    cost { value -2500 mods [ 
                        { #type game-difficulty-modifier hardmultiplier 1.5 easymultiplier 0.5 }
                        { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }
                     reqs [
                        { #type prestige-requirement value 14 sathit -0.2 }
                    ]
                }
            ]
        }
        {   
            id "restaurant-rooftop-12-1"
            type restaurant
            size { x 12 y 1 }
            waithours { value 8 mods [ 
                { #type game-difficulty-modifier harddelta 4 easydelta -2 }
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 0.5 }
                { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
            ] }
            dailyaddprobability { value 0.2 mods [ 
                { #type economy-modifier multiplier 0.2 rounding 0.01 }
                { #type game-difficulty-modifier hardmultiplier 0.5 easymultiplier 1.5 }
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 2 }
                { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 }
                { #type scenario-modifier tags [ "scenario-8"] when pass multiplier 2 } 
            ] }
            minresults { value 1 mods [ 
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 3 }
                { #type scenario-modifier tags [ "scenario-8"] when pass multiplier 2 } 
            ] } 
            maxresults { value 2 mods [ 
                { #type economy-modifier multiplier 1 rounding 0.1 }
                { #type game-difficulty-modifier easydelta 1 }
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 2 }
                { #type scenario-modifier tags [ "scenario-8"] when pass multiplier 2 } 
            ] } 
            entries [
                {
                    id "rest-rooftop-beergarden"
                    locname "moveins.commercial.restaurant.beergarden"
                    tags [ beergarden ]
                    cost { value -1000 mods [ 
                        { #type game-difficulty-modifier hardmultiplier 1.5 easymultiplier 0.5 }
                        { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }
                }
            ]
        }
         {   
            id "restaurant-rooftop-22-1"
            type restaurant
            size { x 22 y 1 }
            waithours { value 2 mods [ 
                { #type game-difficulty-modifier easydelta -6  }
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 0.5 }
                { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
            ] }
            dailyaddprobability { value 0.2 mods [ 
                { #type economy-modifier multiplier 0.2 rounding 0.01 }
                { #type game-difficulty-modifier hardmultiplier 0.5 easymultiplier 1.5 }
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 2 }
                { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 }
                { #type scenario-modifier tags [ "scenario-8"] when pass multiplier 2 } 
            ] }
            minresults { value 1 mods [ 
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 3 }
                { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 }
                { #type scenario-modifier tags [ "scenario-8"] when pass multiplier 2 } 
            ] } 
            maxresults { value 2 mods [ 
                { #type economy-modifier multiplier 1 rounding 0.1 }
                { #type game-difficulty-modifier easydelta 1 }
                { #type golden-age-modifier id goldenage-commercial-feature multiplier 2 }
                { #type scenario-modifier tags [ "scenario-8"] when pass multiplier 2 } 
            ] }  
            entries [
                {
                    id "rest-rooftop-large"
                    locname "moveins.commercial.restaurant.rooftop"
                    tags [ rooftoprest ]
                    cost { value -2500 mods [ 
                        { #type game-difficulty-modifier hardmultiplier 1.5 easymultiplier 0.5 }
                        { #type golden-age-modifier id goldenage-commercial-feature multiplier 0 } 
                    ] }
                }
            ]
        }

        {
            id "residential-6-1"
            type residential
            size { x 6 y 1 }
            instant {
                id "instant-residential-6w"
                title "ui.moveins.residentsready"
                tags [ apt-studio-low apt-studio-high ]
            }
        }
        {
            id "residential-8-1"
            type residential
            size { x 8 y 1 }
            instant {
                id "instant-residential-8w"
                title "ui.moveins.residentsready"
                tags [ apt-1br-low apt-1br-high  ]
            }
        }
        {
            id "residential-10-1"
            type residential
            size { x 10 y 1 }
            instant {
                id "instant-residential-10w"
                title "ui.moveins.residentsready"
                tags [ apt-2br-low apt-2br-high ]
            }
        }
        {
            id "residential-16-1"
            type residential
            size { x 16 y 1 }
            instant {
                id "instant-residential-16w"
                title "ui.moveins.residentsready"
                tags [ apt-large-2br-low apt-large-2br-medium ]
            }
        }
        {
            id "residential-10-2"
            type residential
            size { x 10 y 2 }
            instant {
                id "instant-residential-10w-2t"
                title "ui.moveins.residentsready"
                tags [ apt-large-2br-high ]
            }
        }
        {
            id "residential-15-2"
            type residential
            size { x 15 y 2 }
            instant {
                id "instant-residential-15w-2t"
                title "ui.moveins.residentsready"
                tags [ apt-four-a  apt-four-b ]
            }
        }
        {
            id "residential-roof-14-1"
            type residential
            size { x 14 y 1 }
            instant {
                id "instant-residential-roof-14w"
                title "ui.moveins.residentsready"
                tags [ penthouse-medium ]
            }
        }
        {
            id "residential-roof-20-1"
            type residential
            size { x 20 y 1 }
            instant {
                id "instant-residential-roof-18w"
                title "ui.moveins.residentsready"
                tags [ penthouse-luxury ]
            }
        }
        ]

        services [
        {
            servicetype officeservice
            locname "services.office.header"
            entries [
            {
                template "service-level-one-courier"
                locname "service.one.courier.cat"
                reqs [ { #type tutorial-done-requirement } ]
            }
            {
                template "service-level-one-supplies"
                locname "service.one.supplies.cat"
                reqs [ { #type tutorial-done-requirement } ]
            }
            {
                template "service-level-one-water"
                locname "service.one.water.cat"
                ;; note: no tutorial requirement, because we use this one in the tutorial!
            }
            {
                template "service-level-one-cleaning"
                locname "service.one.cleaning.cat"
                reqs [ { #type tutorial-done-requirement } ]
            }
            {
                template "service-level-one-copies"
                locname "service.one.copies.cat"
                reqs [ { #type tutorial-done-requirement } ]
            }
            {
                template "service-level-two-computers"
                locname "service.two.it.cat"
                reqs [ { #type prestige-requirement value 2 } ]
            }
            {
                template "service-level-two-printer"
                locname "service.two.printer.cat"
                reqs [ { #type prestige-requirement value 2 } ]
            }
            {
                template "service-level-two-storage"
                locname "service.two.storage.cat"
                reqs [ { #type prestige-requirement value 2 } ]
            }
            {
                template "service-level-two-catering"
                locname "service.two.catering.cat"
                reqs [ { #type prestige-requirement value 2 } ]
            }
            {
                template "service-level-three-auditors"
                locname "service.three.auditors.cat"
                reqs [
                    { #type prestige-requirement value 9 }
                ]
            }
            {
                template "service-level-three-design"
                locname "service.three.design.cat"
                reqs [
                    { #type prestige-requirement value 9 }
                ]
            }
            {
                template "service-level-three-tempagency"
                locname "service.three.temps.cat"
                reqs [
                    { #type prestige-requirement value 9 }
                ]
            }
            {
                template "service-level-three-security"
                locname "service.three.security.cat"
                reqs [
                    { #type prestige-requirement value 9 }
                ]
            }
            {
                template "service-level-three-fitness"
                locname "service.three.fitness.cat"
                reqs [
                    { #type prestige-requirement value 9 }
                ]
            }
            {
                template "service-level-four-club"
                locname "service.four.club.cat"
                reqs [
                    { #type prestige-requirement value 14 }
                ]
            }
            {
                template "service-level-four-helicopter"
                locname "service.four.helicopter.cat"
                reqs [
                    { #type prestige-requirement value 14 }
                ]
            }
            {
                template "service-level-four-limo"
                locname "service.four.limo.cat"
                reqs [
                    { #type prestige-requirement value 14 }
                ]
            }

            ]
        }
        {
            servicetype residentialservice
            locname "services.residential.header"
            entries [
            {
                template "service-residential-one-handyman"
                locname "service.residential.handyman.cat"
                reqs [
                ;    { #type entity-count-requirement type atleast count 1 template support-maintenance }
                ]
            }
            {
                template "service-residential-one-plumber"
                locname "service.residential.plumber.cat"
            }
            {
                template "service-residential-one-laundry"
                locname "service.residential.laundry.cat"
                reqs [
               ;     { #type entity-count-requirement type atleast count 1 template support-maintenance }
                    { #type prestige-requirement value 3 }
                ]
            }
            {
                template "service-residential-two-dogs"
                locname "service.residential.dogwalker.cat"
                reqs [
                    { #type prestige-requirement value 4 }
                ]
            }
            {
                template "service-residential-two-cleaners"
                locname "service.residential.cleaning.cat"
                reqs [
                    { #type prestige-requirement value 4 }
                ]
            }
            {
                template "service-residential-three-drycleaning"
                locname "service.residential.drycleaning.cat"
                reqs [
                    { #type prestige-requirement value 5 }
                ]
            }
            {
                template "service-residential-three-flowers"
                locname "service.residential.flowers.cat"
                reqs [
                    { #type prestige-requirement value 5 }
                ]
            }
            {
                template "service-residential-three-tailor"
                locname "service.residential.tailor.cat"
                reqs [
                    { #type prestige-requirement value 5 }
                ]
            }
            {
                template "service-residential-three-daycare"
                locname "service.residential.daycare.cat"
                reqs [
                    { #type prestige-requirement value 5 }
                ]
            }
            {
                template "service-residential-three-dogdaycare"
                locname "service.residential.dogsitting.cat"
                reqs [
                    { #type prestige-requirement value 5 }
                ]
            }
            {
                template "service-residential-three-gym"
                locname "service.residential.gym.cat"
                reqs [
                    { #type prestige-requirement value 5 }
                ]
            }
            {
                template "service-residential-four-yoga"
                locname "service.residential.yoga.cat"
                reqs [
                    { #type prestige-requirement value 10 }
                ]
            }
            {
                template "service-residential-four-decorator"
                locname "service.residential.decorator.cat"
                reqs [
                    { #type prestige-requirement value 10 }
                ]
            }
            {
                template "service-residential-four-finance"
                locname "service.residential.finance.cat"
                reqs [
                    { #type prestige-requirement value 10 }
                ]
            }
            ]
        }
        ]


        vending [
            ;; image index: 0 = common, 1 = machines, 2 = news,
            ;;              3 = payphones, 4 = shoe shine, 5 = snacks
            {   
                template "vending-machines"
                locname "vending.machines.cardname"
                locmouseover "vending.machines.cardmo"
                imageindex 1
                reqs [
                    { #type scenario-requirement tags [ "scenario-5" "scenario-6" ] result fail }
                    { #type prestige-requirement value 1 }
                ]
            }
            
            {
                template "vending-phones"
                locname "vending.phones.cardname"
                locmouseover "vending.phones.cardmo"
                imageindex 3
                reqs [
                    { #type prestige-requirement value 2 }
                ]
            }
            
            {
                template "vending-shoeshine"
                locname "vending.shoeshine.cardname"
                locmouseover "vending.shoeshine.cardmo"
                imageindex 4
                reqs [
                    { #type prestige-requirement value 1 }
                ]
            }
            {
                template "common-areas"
                locname "vending.commonarea.cardname"
                locmouseover "vending.commonarea.cardmo"
                imageindex 0
                reqs [
                    { #type scenario-requirement tags [ "scenario-1" "scenario-8" "scenario-3" "scenario-12" ] result fail }
                   { #type prestige-requirement value 3 }
                ]
            }
;            {   
;                template "vending-test"
;                locname "vending.test.name"
;                locmouseover "vending.test.mo"
;                imageindex 3
;                visreqs [
;                    { #type prestige-requirement value 10 }
;                ]
;                reqs [
;                    { #type prestige-requirement value 15 }
;                ]
;            }
        ]

        consultants [ ;; N tracks x 5 upgrades

        {
            id "cons-a"
            locname "cons.a.track.title"
            locdesc "cons.a.track.desc"
            locoffice "cons.a.track.needed"
            template "consultant-aesthetics"
            templatehint "cons.a.templatehint"

            reqs [
                { #type entity-count-requirement type atleast count 1 template "consultant-aesthetics" onlyenabled #true }
            ]

            upgrades [
            {
                id "cons-a-1" locname "cons.a.1" locdesc "cons.a.1.desc"
                reqs [
                    { #type entity-count-requirement type atleast count 1 template "consultant-aesthetics" }
                ]
            ;    cashcost { value -500 mods [ { #type game-difficulty-modifier hardmultiplier 1.5 easymultiplier 0.5 } ] }
            }
            {
                id "cons-a-2" locname "cons.a.2" locdesc "cons.a.2.desc"
                reqs [
                    { #type entity-count-requirement type atleast count 1 template "consultant-aesthetics" }
                    { #type consultant-upgrade-requirement id "cons-a-1" }
                ]
            ;    cashcost { value -2500 mods [ { #type game-difficulty-modifier hardmultiplier 1.5 easymultiplier 0.5 } ] }
            }
            {
                id "cons-a-3" locname "cons.a.3" locdesc "cons.a.3.desc"
                reqs [
                    { #type entity-count-requirement type atleast count 1 template "consultant-aesthetics" }
                    { #type consultant-upgrade-requirement id "cons-a-2" }
                ]
            ;    cashcost { value -5000 mods [ { #type game-difficulty-modifier hardmultiplier 1.5 easymultiplier 0.5 } ] }
            }
            {
                id "cons-a-4" locname "cons.a.4" locdesc "cons.a.4.desc"
                reqs [
                    { #type entity-count-requirement type atleast count 1 template "consultant-aesthetics" }
                    { #type consultant-upgrade-requirement id "cons-a-3" }
                ]
            ;    cashcost { value -5000 mods [ { #type game-difficulty-modifier hardmultiplier 1.5 easymultiplier 0.5 } ] }
            }
            {
                id "cons-a-5" locname "cons.a.5" locdesc "cons.a.5.desc"
                reqs [
                    { #type entity-count-requirement type atleast count 1 template "consultant-aesthetics" }
                    { #type consultant-upgrade-requirement id "cons-a-4" }
                ]
            ;    cashcost { value -10000 mods [ { #type game-difficulty-modifier hardmultiplier 1.5 easymultiplier 0.5 } ] }
            }
            ]
        }

        {
            id "cons-b"
            locname "cons.b.track.title"
            locdesc "cons.b.track.desc"
            locoffice "cons.b.track.needed"
            template "consultant-civics"
            templatehint "cons.b.templatehint"

            reqs [
                { #type entity-count-requirement type atleast count 1 template "consultant-civics" onlyenabled #true }
            ]

            upgrades [
            {
                id "cons-b-1" locname "cons.b.1" locdesc "cons.b.1.desc"
                reqs [
                    { #type entity-count-requirement type atleast count 1 template "consultant-civics" }
                    { #type prestige-requirement value 1 }
                ]
            ;    cashcost { value -500 mods [ { #type game-difficulty-modifier hardmultiplier 1.5 easymultiplier 0.5 } ] }
            }
            {
                id "cons-b-2" locname "cons.b.2" locdesc "cons.b.2.desc"
                reqs [
                    { #type entity-count-requirement type atleast count 1 template "consultant-civics" }
                    { #type prestige-requirement value 5 }
                    { #type consultant-upgrade-requirement id "cons-b-1" }
                    { #type scenario-meta-requirement tags [ "scenario-14" ]
                        reqs [ { #type medals-achieved-requirement scenarioid "scenario-14" } ] 
                        otherwise pass }
                ]
            ;    cashcost { value -1500 mods [ { #type game-difficulty-modifier hardmultiplier 1.5 easymultiplier 0.5 } ] }
                mouseover "cons.b.2.specialmouseover"
                action "civic-unlock-height-cap"
            }
            {
                id "cons-b-3" locname "cons.b.3" locdesc "cons.b.3.desc"
                reqs [
                    { #type entity-count-requirement type atleast count 1 template "consultant-civics" }
                    { #type prestige-requirement value 5 }
                    { #type consultant-upgrade-requirement id "cons-b-2" }
                ]
            ;    cashcost { value -2500 mods [ { #type game-difficulty-modifier hardmultiplier 1.5 easymultiplier 0.5 } ] }
            }
            {
                id "cons-b-4" locname "cons.b.4" locdesc "cons.b.4.desc"
                reqs [
                    { #type entity-count-requirement type atleast count 1 template "consultant-civics" }
                    { #type prestige-requirement value 5 }
                    { #type consultant-upgrade-requirement id "cons-b-3" }
                    { #type plaza-upgrade-requirement }
                ]
            ;    cashcost { value -5000 mods [ { #type game-difficulty-modifier hardmultiplier 1.5 easymultiplier 0.5 } ] }
                mouseover "cons.b.4.specialmouseover"
                action "civic-unlock-floor-space"
            }
            {
                id "cons-b-5" locname "cons.b.5" locdesc "cons.b.5.desc"
                reqs [
                    { #type entity-count-requirement type atleast count 1 template "consultant-civics" }
                    { #type prestige-requirement value 5 }
                    { #type consultant-upgrade-requirement id "cons-b-4" }
                ]
            ;    cashcost { value -5000 mods [ { #type game-difficulty-modifier hardmultiplier 1.5 easymultiplier 0.5 } ] }
            }
            ]
        }
        {
            id "cons-c"
            locname "cons.c.track.title"
            locdesc "cons.c.track.desc"
            locoffice "cons.c.track.needed"
            template "consultant-building"
            templatehint "cons.c.templatehint"

            reqs [
                { #type entity-count-requirement type atleast count 1 template "consultant-building" onlyenabled #true }
            ]

            upgrades [
            {
                id "cons-c-1" locname "cons.c.1" locdesc "cons.c.1.desc"
                reqs [
                    { #type entity-count-requirement type atleast count 1 template "consultant-building" }
                ]
                cashcost { value -500 mods [ { #type game-difficulty-modifier hardmultiplier 1.5 easymultiplier 0.5 } ] }
            }
            {
                id "cons-c-2" locname "cons.c.2" locdesc "cons.c.2.desc"
                reqs [
                    { #type entity-count-requirement type atleast count 1 template "consultant-building" }
                    { #type entity-count-requirement type atleast count 1 template "support-construction-expanded" }
                    { #type consultant-upgrade-requirement id "cons-c-1" }
                ]
            ;    cashcost { value -2500 mods [ { #type game-difficulty-modifier hardmultiplier 1.5 easymultiplier 0.5 } ] }
            }
            
            {
                ;; NOTE: id "cons-c-4" is hard-coded to unlock "makes service workers 2x faster" -
                ;; see ConsultantUpgradeConstants.BUILDING_WORKERS
                id "cons-c-3" locname "cons.c.3" locdesc "cons.c.3.desc"
                reqs [
                    { #type entity-count-requirement type atleast count 1 template "consultant-building" }
                    { #type consultant-upgrade-requirement id "cons-c-2" }
                ]
            ;    cashcost { value -5000 mods [ { #type game-difficulty-modifier hardmultiplier 1.5 easymultiplier 0.5 } ] }
            }
            {
                ;; NOTE: id "cons-c-4" is hard-coded to unlock "makes building workers 2x faster" -
                ;; see ConsultantUpgradeConstants.SERVICE_WORKERS
                id "cons-c-4" locname "cons.c.4" locdesc "cons.c.4.desc"
                reqs [
                    { #type entity-count-requirement type atleast count 1 template "consultant-building" }
                    { #type consultant-upgrade-requirement id "cons-c-3" }
                ]
            ;    cashcost { value -5000 mods [ { #type game-difficulty-modifier hardmultiplier 1.5 easymultiplier 0.5 } ] }
            }
            {
                id "cons-c-5" locname "cons.c.5" locdesc "cons.c.5.desc"
                reqs [
                    { #type entity-count-requirement type atleast count 1 template "consultant-building" }
                    { #type consultant-upgrade-requirement id "cons-c-4" }
                ]
            ;    cashcost { value -5000 mods [ { #type game-difficulty-modifier hardmultiplier 1.5 easymultiplier 0.5 } ] }
            }
            
            ]
        }
        ]

        ratings [ {
            id      score-restaurant-small
            tags    [ restaurant-1a restaurant-1b restaurant-1c restaurant-1d restaurant-1e ]
            reqkey  "reqs.rating.rest1"
        } {
            id      score-restaurant-medium
            tags    [ restaurant-2a restaurant-2b restaurant-2c restaurant-2d restaurant-2e ]
            reqkey  "reqs.rating.rest2"
        } {
            id      score-restaurant-large
            tags    [ restaurant-3a restaurant-3b restaurant-3c ]
            reqkey  "reqs.rating.rest3"
        } {
            id      score-retail-small
            tags    [ retail-one-a retail-one-b retail-one-c retail-one-d retail-one-e-bottle retail-one-e-flowers ]
            reqkey  "reqs.rating.ret1"
        } {
            id      score-retail-medium
            tags    [ retail-two-a retail-two-b retail-two-c-shoes retail-two-c-purses retail-two-d ]
            reqkey  "reqs.rating.ret2"
        } {
            id      score-retail-large
            tags    [ clothing-three fashion-three homegoods-three electronics-three food-three ]
            reqkey  "reqs.rating.ret3"
        } {
            id      score-office-medical
            tags    [ medical-two medical-three ]
            reqkey  "reqs.rating.medical"
        } {
            id      score-office-legal
            tags    [ legal-one legal-two ]
            reqkey  "reqs.rating.legal"
        } {
            id      score-office-creative
            tags    [ creative-one creative-two creative-three ]
            reqkey  "reqs.rating.creative"
        } {
            id      score-office-technical
            tags    [ tech-two tech-three ]
            reqkey  "reqs.rating.technical"
        } {
            id      score-office-financial
            tags    [ financial-one financial-two financial-three ]
            reqkey  "reqs.rating.financial"
        } {
            id      score-restaurant-bar
            tags    [ bar-three bar-four beergarden ]
            reqkey  "reqs.rating.restaurants.bar"
        } {
            id      score-restaurant-cafe
            tags    [ cafe ]
            reqkey  "reqs.rating.restaurants.cafe"
        } {
            id      score-restaurant-foodcourt
            tags    [ foodcourt ]
            reqkey  "reqs.rating.restaurants.foodcourt"
        } {
            id      score-restaurant-breakfast
            tags    [ breakfast-one breakfast-two breakfast-three breakfast-four ]
            reqkey  "reqs.rating.restaurants.breakfast"
        } {
            id      score-restaurant-lunch
            tags    [ lunch-one lunch-two lunch-three breakfast-four beergarden ]
            reqkey  "reqs.rating.restaurants.lunch"
        } {
            id      score-restaurant-dinner
            tags    [ dinner-two dinner-three dinner-four beergarden rooftoprest ]
            reqkey  "reqs.rating.restaurants.dinner"
        } {
            id      score-restaurant-gourmet
            tags    [ chinese indian seafood thai french japanese ]
            reqkey  "reqs.rating.restaurants.gourmet"
        } {
            id      score-restaurant-exclusive
            tags    [ french japanese ]
            reqkey  "reqs.rating.restaurants.exclusive"
        } {
            id      score-retail-food
            tags    [ food-one food-three ]
            reqkey  "reqs.rating.retail.food"
        } {
            id      score-retail-electronics
            tags    [ electronics-one electronics-two electronics-three ]
            reqkey  "reqs.rating.retail.electronics"
        } {
            id      score-retail-clothing
            tags    [ clothing-two clothing-three ]
            reqkey  "reqs.rating.retail.clothing"
        } {
            id      score-retail-homegoods
            tags    [ homegoods-one homegoods-two ]
            reqkey  "reqs.rating.retail.homegoods"
        } {
            id      score-retail-luxury
            tags    [ retail-four-a retail-four-b retail-four-c retail-four-e retail-four-d retail-four-e ]
            reqkey  "reqs.rating.retail.luxury"
        } {
            id      score-retail-exclusive
            tags    [ retail-four-d retail-four-e ]
            reqkey  "reqs.rating.retail.exclusive"
        } {
            id      score-retail-fashion
            tags    [ fashion-two fashion-three ]
            reqkey  "reqs.rating.retail.fashion"
        } {
            id      score-residential-normal
            tags    [ normal-one normal-two normal-three ]
            reqkey  "reqs.rating.residential.normal"
        } {
            id      score-residential-luxury
            tags    [ lux-one lux-1br lux-two lux-three penthouse-luxury penthouse-medium ]
            reqkey  "reqs.rating.residential.luxury"
            } ]
    }

    tags {
        ;; maps from tag type to its effect on rating
        all {
            ;; default category tags
            rest-type-coffee 0 ;; default tags don't get scored
            rest-type-lunch 0
            rest-type-dinner 0
            rest-type-breakfast 0
            rest-type-bar 0

            ;; restaurants
            restaurant-1a 1
            restaurant-1b 1
            restaurant-1c 1
            restaurant-1d 1
            restaurant-1e 1
            restaurant-2a 1
            restaurant-2b 1
            restaurant-2c 1
            restaurant-2d 1
            restaurant-2e 1
            restaurant-3a 1
            restaurant-3b 1
            restaurant-3c 1

            ;; restaurant tracks
            foodcourt 1
            cafe 1
            lunch-one 1
            breakfast-one 1
            lunch-two 2
            breakfast-two 2
            dinner-two 1
            breakfast-three 2
            lunch-three 2
            dinner-three 2
            bar-three 2
            dinner-four 1
            lunch-four 3
            breakfast-four 3
            bar-four 3
            chinese 1
            indian 1
            seafood 1
            thai 1
            french 1
            japanese 1
            beergarden 2
            rooftoprest 3


            ;; services
            courier  0
            supplies 0
            water    0
            copies   0
            cleaning 0
            computers 0
            printer  0
            storage  0
            catering 0
            service-three-typeone 0
            service-three-typetwo 0

            ;; retail
            retail-one-a 1
            retail-one-b 1
            retail-one-c 1
            retail-one-d 1
            retail-one-e-bottle 1
            retail-one-e-flowers 1
            retail-two-a 1
            retail-two-b 1
            retail-two-c-shoes 1
            retail-two-c-purses 1
            retail-two-d 1
            retail-four-a 1
            retial-four-b 1
            retail-four-c 1
            retail-four-d 1
            retail-four-e 1
            retail-four-f 1


            ;; retail-tracks
            food-one 1
            electronics-one 1
            homegoods-one 1
            clothing-two 2
            electronics-two 2
            fashion-two 2
            homegoods-two 2
            clothing-three 3
            fashion-three 3
            homegoods-three 3
            electronics-three 3
            food-three 3

            ;;office tracks
            financial-one 1
            legal-one 1
            creative-one 1
            legal-two 2
            medical-two 2
            financial-two 2
            creative-two 2
            tech-two 2
            financial-three 3
            creative-three 3
            tech-three 3
            medical-three 3


            ;; apartments
            normal-one 1
            lux-one 1
            lux-1br 2
            normal-two 1
            lux-two 3
            normal-three 1
            lux-three 4
            penthouse-medium 3
            penthouse-luxury 5
        }
    }

    residents {
        archetypes {
            "students-two" {
                people [
                    {
                        templategroups [ "npc-resident-student*" ]
                    count { from 2 to 2 }
                    gender u
                    adult #true
                    }

                ]
            }
            "retirees-two" {
                people [
                    {
                        templategroups [ "npc-resident-retiree*" ]
                    count { from 2 to 2 }
                    gender u
                    adult #true
                    }
                ]
            }
            ; single people
            "students-single" {
                people [
                    {
                        templategroups [ "npc-resident-student*" ]
                    count { from 1 to 1 }
                    gender u
                    adult #true
                    }

                ]
            }
            "retirees-single" {
                people [
                    {
                        templategroups [ "npc-resident-retiree-low*" ]
                    count { from 1 to 1 }
                    gender u
                    adult #true
                    }
                ]
            }
            "worker-low-single" {
                people [
                    {
                        templategroups [ "npc-resident-worker-low-*" ]
                    count { from 1 to 1 }
                    gender u
                    adult #true
                    }
                ]
            }
            "worker-med-single" {
                people [
                    {
                        templategroups [ "npc-resident-worker-med-*" ]
                    count { from 1 to 1 }
                    gender u
                    adult #true
                    }
                ]
            }
            "worker-high-single" {
                people [
                    {
                        templategroups [ "npc-resident-worker-high-*" ]
                    count { from 1 to 1 }
                    gender u
                    adult #true
                    }
                ]
            }
            ;; both work, no kids
            "worker-low-2w" {
                people [
                    {
                        templategroups [ "npc-resident-worker-low-*" ]
                    count { from 2 to 2 }
                    gender u
                    adult #true
                    }
                ]
            }
            "worker-med-2w" {
                people [
                    {
                        templategroups [ "npc-resident-worker-med-*" ]
                    count { from 2 to 2 }
                    gender u
                    adult #true
                    }
                ]
            }
            "worker-high-2w" {
                people [
                    {
                        templategroups [ "npc-resident-worker-high-*" ]
                    count { from 2 to 2 }
                    gender u
                    adult #true
                    }
                ]
            }
            ;; one works, one stays at home, no kids
            "worker-low-1w" {
                people [
                    {
                        templategroups [ "npc-resident-worker-low-*" ]
                    count { from 1 to 1 }
                    gender u
                    adult #true
                    }
                    {
                        templategroups [ "npc-resident-stayathomespouse-low*" ]
                    count { from 1 to 1 }
                    gender u
                    adult #true
                    }
                ]
            }
            "worker-med-1w" {
                people [
                    {
                        templategroups [ "npc-resident-worker-med-*" ]
                    count { from 1 to 1 }
                    gender u
                    adult #true
                    }
                    {
                        templategroups [ "npc-resident-stayathomespouse-med*" ]
                    count { from 1 to 1 }
                    gender u
                    adult #true
                    }
                ]
            }
            "worker-high-1w" {
                people [
                    {
                        templategroups [ "npc-resident-worker-high-*" ]
                    count { from 1 to 1 }
                    gender u
                    adult #true
                    }
                    {
                        templategroups [ "npc-resident-stayathomespouse-high*" ]
                    count { from 1 to 1 }
                    gender u
                    adult #true
                    }
                ]
            }
            ;; one works, one works at home, no kids
            "worker-low-1w1-wah" {
                people [
                    {
                        templategroups [ "npc-resident-worker-low-*" ]
                    count { from 1 to 1 }
                    gender u
                    adult #true
                    }
                    {
                        templategroups [ "npc-resident-worksathome-low*" ]
                    count { from 1 to 1 }
                    gender u
                    adult #true
                    }
                ]
            }
            "worker-med-1w-1wah" {
                people [
                    {
                        templategroups [ "npc-resident-worker-med-*" ]
                    count { from 1 to 1 }
                    gender u
                    adult #true
                    }
                    {
                        templategroups [ "npc-resident-worksathome-med*" ]
                    count { from 1 to 1 }
                    gender u
                    adult #true
                    }
                ]
            }
            "worker-high-1w-1wah" {
                people [
                    {
                        templategroups [ "npc-resident-worker-high-*" ]
                    count { from 1 to 1 }
                    gender u
                    adult #true
                    }
                    {
                        templategroups [ "npc-resident-worksathome-high*" ]
                    count { from 1 to 1 }
                    gender u
                    adult #true
                    }
                ]
            }
            ;; both work, kids
            "worker-low-2w-kids" {
                people [
                    {
                        templategroups [ "npc-resident-worker-low-*" ]
                    count { from 2 to 2 }
                    gender u
                    adult #true
                    }
                    {
                        templategroups [ "npc-kids*" ]
                    count { from 1 to 1 }
                    gender u
                    adult #false
                    }
                ]
            }
            "worker-med-2w-kids" {
                people [
                    {
                        templategroups [ "npc-resident-worker-med-*" ]
                    count { from 2 to 2 }
                    gender u
                    adult #true
                    }
                    {
                        templategroups [ "npc-kids*" ]
                    count { from 1 to 1 }
                    gender u
                    adult #false
                    }
                ]
            }
            "worker-high-2w-kids" {
                people [
                    {
                        templategroups [ "npc-resident-worker-high-*" ]
                    count { from 2 to 2 }
                    gender u
                    adult #true
                    }
                    {
                        templategroups [ "npc-kids*" ]
                    count { from 1 to 1 }
                    gender u
                    adult #false
                    }
                ]
            }
            ;; one works, one stays at home, kids
            "worker-low-1w-kids" {
                people [
                    {
                        templategroups [ "npc-resident-worker-low-*" ]
                    count { from 1 to 1 }
                    gender u
                    adult #true
                    }
                    {
                        templategroups [ "npc-kids*" ]
                    count { from 1 to 1 }
                    gender u
                    adult #false
                    }
                ]
            }
            "worker-med-1w-kids" {
                people [
                    {
                        templategroups [ "npc-resident-worker-med-*" ]
                    count { from 1 to 1 }
                    gender u
                    adult #true
                    }
                    {
                        templategroups [ "npc-resident-stayathomespouse-med*" ]
                    count { from 1 to 1 }
                    gender u
                    adult #true
                    }
                    {
                        templategroups [ "npc-kids*" ]
                    count { from 1 to 1 }
                    gender u
                    adult #false
                    }
                ]
            }
            "worker-high-1w-kids" {
                people [
                    {
                        templategroups [ "npc-resident-worker-high-*" ]
                    count { from 1 to 1 }
                    gender u
                    adult #true
                    }
                    {
                        templategroups [ "npc-resident-stayathomespouse-high*" ]
                    count { from 1 to 1 }
                    gender u
                    adult #true
                    }
                    {
                        templategroups [ "npc-kids*" ]
                    count { from 1 to 1 }
                    gender u
                    adult #false
                    }
                ]
            }
            "no-workers" {
                people [
                    {
                        templategroups [ "npc-resident-stayathomespouse-high*" ]
                    count { from 1 to 2 }
                    gender u
                    adult #true
                    }
                ]
            }
        }


        waitlists [
            {
                name "apt-1br-studio-low"
                locdesc "ui.waitlist.one.studio"
                tags [ apt-studio-low ]
                hourlyprob { value 0.1 mods [ 
                    { #type economy-modifier multiplier 0.05 rounding 0.001 }
                    { #type game-difficulty-modifier easymultiplier 2 }
                    { #type golden-age-modifier id goldenage-apartments-waitlist multiplier 10 }
                    { #type scenario-modifier tags [ "scenario-5 "] when pass multiplier 10 }
                    { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
                ] }
                maxwaiting { value 4 mods [ 
                    { #type economy-modifier multiplier 2 rounding 0.1 }
                    { #type game-difficulty-modifier hardmultiplier 0.5 easymultiplier 1.5 }
                    { #type golden-age-modifier id goldenage-apartments-waitlist multiplier 2 }
                    { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
                ] }
                archetypes [ worker-low-single students-single retirees-single ]
            }
            {
                name "apt-1br-studio-high"
                locdesc "ui.waitlist.one.studio"
                tags [ apt-studio-high ]
                hourlyprob { value 0.075 mods [ 
                    { #type economy-modifier multiplier 0.025 rounding 0.0001 }
                    { #type game-difficulty-modifier easymultiplier 2 }
                    { #type golden-age-modifier id goldenage-apartments-waitlist multiplier 10 }
                    { #type scenario-modifier tags [ "scenario-5 "] when pass multiplier 10 }
                    { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
                ] }
                maxwaiting { value 2 mods [ 
                    { #type economy-modifier multiplier 1 rounding 0.1 }
                    { #type game-difficulty-modifier hardmultiplier 0.5 easymultiplier 1.5 }
                    { #type golden-age-modifier id goldenage-apartments-waitlist multiplier 2 }
                    { #type scenario-modifier tags [ "scenario-5 "] when pass multiplier 2 }
                    { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
                ] }
                archetypes [ worker-med-single retirees-single ]
            }
            {
                name "apt-1br-low"
                locdesc "ui.waitlist.one.lowend"
                tags [ apt-1br-low ]
                hourlyprob { value 0.1 mods [ 
                    { #type economy-modifier multiplier 0.05 rounding 0.001 }
                    { #type game-difficulty-modifier easymultiplier 2 }
                    { #type golden-age-modifier id goldenage-apartments-waitlist multiplier 10 }
                    { #type scenario-modifier tags [ "scenario-5 "] when pass multiplier 10 }
                    { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
                ] }
                maxwaiting { value 4 mods [ 
                    { #type economy-modifier multiplier 2 rounding 0.1 }
                    { #type game-difficulty-modifier hardmultiplier 0.5 easymultiplier 1.5 }
                    { #type golden-age-modifier id goldenage-apartments-waitlist multiplier 2 }
                    { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
                ] }
                archetypes [ worker-low-single worker-low-single students-single retirees-single worker-med-single worker-low-2w worker-low-1w ]
            }
            {
                name "apt-1br-high"
                locdesc "ui.waitlist.one.highend"
                tags [ apt-1br-high ]
                hourlyprob { value 0.05 mods [ 
                    { #type economy-modifier multiplier 0.025 rounding 0.0001 }
                    { #type game-difficulty-modifier easymultiplier 2 }
                    { #type golden-age-modifier id goldenage-apartments-waitlist multiplier 10 }
                    { #type scenario-modifier tags [ "scenario-5 "] when pass multiplier 10 }
                    { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
                ] }
                maxwaiting { value 2 mods [ 
                    { #type economy-modifier multiplier 1 rounding 0.1 }
                    { #type game-difficulty-modifier easymultiplier 1.5 }
                    { #type golden-age-modifier id goldenage-apartments-waitlist multiplier 2 }
                    { #type scenario-modifier tags [ "scenario-5 "] when pass multiplier 2 }
                    { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
                ] }
                archetypes [ worker-med-single worker-med-2w retirees-two ]
            }
            {
                name "apt-2br-low"
                locdesc "ui.waitlist.two.lowend"
                tags [ apt-2br-low ]
                hourlyprob { value 0.1 mods [ 
                    { #type economy-modifier multiplier 0.05 rounding 0.001 }
                    { #type game-difficulty-modifier easymultiplier 2 }
                    { #type golden-age-modifier id goldenage-apartments-waitlist multiplier 10 }
                    { #type scenario-modifier tags [ "scenario-5 "] when pass multiplier 10 } 
                ] }
                maxwaiting { value 4 mods [ 
                    { #type economy-modifier multiplier 2 rounding 0.1 }
                    { #type game-difficulty-modifier hardmultiplier 0.5 easymultiplier 1.5 }
                    { #type golden-age-modifier id goldenage-apartments-waitlist multiplier 2 }
                    { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
                ] }
                archetypes [ worker-low-2w worker-low-1w worker-low-2w-kids worker-low-1w-kids worker-low-1w1-wah ]
            }
            {
                name "apt-2br-high"
                locdesc "ui.waitlist.two.highend"
                tags [ apt-2br-high ]
                hourlyprob { value 0.05 mods [ 
                    { #type economy-modifier multiplier 0.025 rounding 0.001 }
                    { #type game-difficulty-modifier easymultiplier 2 }
                    { #type golden-age-modifier id goldenage-apartments-waitlist multiplier 10 }
                    { #type scenario-modifier tags [ "scenario-5 "] when pass multiplier 10 }
                    { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
                ] }
                maxwaiting { value 2 mods [ 
                    { #type economy-modifier multiplier 1 rounding 0.1 }
                    { #type game-difficulty-modifier easymultiplier 1.5 }
                    { #type golden-age-modifier id goldenage-apartments-waitlist multiplier 2 }
                    { #type scenario-modifier tags [ "scenario-5 "] when pass multiplier 2 }
                    { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
                ] }
                archetypes [ worker-med-2w worker-med-1w worker-med-2w-kids worker-med-1w-kids worker-med-1w-1wah ]
            }
            {
                name "apt-large-2br-low"
                locdesc "ui.waitlist.three.lowend"
                tags [ apt-large-2br-low ]
                hourlyprob { value 0.1 mods [ 
                    { #type economy-modifier multiplier 0.5 rounding 0.01 }
                    { #type game-difficulty-modifier easymultiplier 2 }
                    { #type golden-age-modifier id goldenage-apartments-waitlist multiplier 10 }
                    { #type scenario-modifier tags [ "scenario-5 "] when pass multiplier 10 }
                    { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
                ] }
                maxwaiting { value 4 mods [ 
                    { #type economy-modifier multiplier 2 rounding 0.1 }
                    { #type game-difficulty-modifier hardmultiplier 0.5 easymultiplier 1.5 }
                    { #type golden-age-modifier id goldenage-apartments-waitlist multiplier 2 }
                    { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
                ] }
                archetypes [ worker-low-2w worker-low-1w worker-low-2w-kids worker-low-1w-kids worker-low-1w1-wah ]
            }
            {
                name "apt-large-2br-medium"
                locdesc "ui.waitlist.three.medium"
                tags [ apt-large-2br-medium ]
                hourlyprob { value 0.1 mods [ 
                    { #type economy-modifier multiplier 0.5 rounding 0.01 }
                    { #type game-difficulty-modifier easymultiplier 2 }
                    { #type golden-age-modifier id goldenage-apartments-waitlist multiplier 10 }
                    { #type scenario-modifier tags [ "scenario-5 "] when pass multiplier 10 }
                    { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
                ] }
                maxwaiting { value 3 mods [ 
                    { #type economy-modifier multiplier 2 rounding 0.1 }
                    { #type game-difficulty-modifier hardmultiplier 0.5 easymultiplier 1.5 }
                    { #type golden-age-modifier id goldenage-apartments-waitlist multiplier 2 }
                    { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
                ] }
                archetypes [ worker-med-2w worker-med-2w-kids worker-med-1w-1wah worker-med-1w worker-med-1w-kids ]
            }
            {
                name "apt-large-2br-high"
                locdesc "ui.waitlist.three.high"
                tags [ apt-large-2br-high ]
                hourlyprob { value 0.05 mods [ 
                    { #type economy-modifier multiplier 0.025 rounding 0.01 }
                    { #type game-difficulty-modifier easymultiplier 2 }
                    { #type golden-age-modifier id goldenage-apartments-waitlist multiplier 10 }
                    { #type scenario-modifier tags [ "scenario-5 "] when pass multiplier 10 }
                    { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
                ] }
                maxwaiting { value 1 mods [ 
                    { #type game-difficulty-modifier easymultiplier 2 }
                    { #type golden-age-modifier id goldenage-apartments-waitlist multiplier 2 }
                    { #type scenario-modifier tags [ "scenario-5 "] when pass multiplier 2 }
                    { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
                ] }
                archetypes [ worker-high-2w worker-high-2w-kids worker-high-1w-1wah worker-high-1w worker-high-1w-kids ]
            }
            {
                name "apt-four-a"
                locdesc "ui.waitlist.four.a"
                tags [ apt-four-a ]
                hourlyprob { value 0.1 mods [ 
                    { #type economy-modifier multiplier 0.025 rounding 0.01 }
                    { #type golden-age-modifier id goldenage-apartments-waitlist multiplier 10 }
                    { #type scenario-modifier tags [ "scenario-5 "] when pass multiplier 10 }
                    { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
                ] }
                maxwaiting { value 1 mods [ 
                    { #type golden-age-modifier id goldenage-apartments-waitlist multiplier 2 }
                    { #type scenario-modifier tags [ "scenario-5 "] when pass multiplier 2 }
                    { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
                ] }
                archetypes [ worker-high-2w worker-high-2w-kids worker-high-1w worker-high-1w-kids ]
            }
            {
                name "apt-four-b"
                locdesc "ui.waitlist.four.b"
                tags [ apt-four-b ]
                hourlyprob { value 0.1 mods [ 
                    { #type economy-modifier multiplier 0.025 rounding 0.01 }
                    { #type golden-age-modifier id goldenage-apartments-waitlist multiplier 10 }
                    { #type scenario-modifier tags [ "scenario-5 "] when pass multiplier 10 }
                    { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
                ] }
                maxwaiting { value 1 mods [ 
                    { #type golden-age-modifier id goldenage-apartments-waitlist multiplier 2 }
                    { #type scenario-modifier tags [ "scenario-5 "] when pass multiplier 2 }
                    { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
                ] }
                archetypes [ worker-high-2w worker-high-1w no-workers ]
            }
            {
                name "penthouse-medium"
                locdesc "ui.waitlist.penthouse.medium"
                tags [ penthouse-medium ]
                hourlyprob { value 0.1 mods [ 
                    { #type economy-modifier multiplier 0.025 rounding 0.01 }
                    { #type golden-age-modifier id goldenage-apartments-waitlist multiplier 10 }
                    { #type scenario-modifier tags [ "scenario-5 "] when pass multiplier 10 }
                    { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
                ] }
                maxwaiting { value 1 mods [ 
                    { #type golden-age-modifier id goldenage-apartments-waitlist multiplier 2 }
                    { #type scenario-modifier tags [ "scenario-5 "] when pass multiplier 2 }
                    { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
                ] }
                archetypes [ worker-high-2w worker-high-1w retirees-two worker-med-2w worker-med-1w ]
            }
            {
                name "penthouse-luxury"
                locdesc "ui.waitlist.penthouse.lux"
                tags [ penthouse-luxury ]
                hourlyprob { value 0.1 mods [ 
                    { #type economy-modifier multiplier 0.025 rounding 0.01 }
                    { #type golden-age-modifier id goldenage-apartments-waitlist multiplier 10 }
                    { #type scenario-modifier tags [ "scenario-5 "] when pass multiplier 10 }
                    { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
                ] }
                maxwaiting { value 1 mods [ 
                    { #type golden-age-modifier id goldenage-apartments-waitlist multiplier 2 }
                    { #type scenario-modifier tags [ "scenario-5 "] when pass multiplier 2 }
                    { #type scenario-modifier tags [ "scenario-7"] when pass multiplier 0.5 } 
                ] }
                archetypes [ worker-high-2w worker-high-1w retirees-two ]
            }
        ]
    }

    schedules {
        alltasknames [
            go-sleep-at-home go-putter-at-home go-work-at-workstation go-work-tasks go-stay-offsite
            go-get-coffee go-get-breakfast go-get-lunch go-get-dinner go-get-drink
            go-run-errand-1h go-run-errand-2h go-get-vending
            go-visit-target go-visit-civic go-visit-retail go-end-visit
            ;; go-to-store go-to-movie  ;; not used?
        ]
        definitions [

            ;;;;;; office workers

            ;basic office worker. just needs lunch sometimes.
            {
                name "schedule-office.1"
                blocks [
                    { from 8 to 16.5 tasks [ go-work-at-workstation ] }
                    { from 16.5 to 8 tasks [ go-stay-offsite ] }
                ]
                oneshots [
                    { at 12 prob 0.5 tasks [ go-get-lunch ] }
                    { at 12 prob 0.25 tasks [ go-visit-retail ] }
                    { at 14 prob 0.5 tasks [ go-get-vending ] }
                    { at 16.5 prob 0.5 tasks [ go-visit-retail ] }
                ]
            }

            ;basic office worker. just needs lunch sometimes.
            {
                name "schedule-office.2"
                blocks [
                    { from 10 to 18 tasks [ go-work-at-workstation ] }
                    { from 18 to 10 tasks [ go-stay-offsite ] }
                ]
                oneshots [
                    { at 13.5 prob 0.5 tasks [ go-get-lunch ] }
                    { at 13.5 prob 0.25 tasks [ go-visit-retail ] }
                    { at 13.5 prob 0.5 tasks [ go-visit-retail ] }
                    { at 15.5 prob 0.5 tasks [ go-get-vending ] }
                ]
            }

            ;office worker that goes to offsite meetings sometimes. always wants lunch. sometimes coffee.
            {
                name "schedule-office.3"
                blocks [
                    { from 9 to 17 tasks [ go-work-at-workstation ] }
                    { from 17 to 9 tasks [ go-stay-offsite ] }
                ]
                oneshots [
                    { at 12 prob 1 tasks [ go-get-lunch ] }
                    { at 12 prob 0.25 tasks [ go-visit-retail ] }
                    { at 9 prob 0.75 tasks [ go-get-coffee ] }
                    { at 14 prob 0.5 tasks [ go-get-vending ] }
                    { at 14 prob 0.25 tasks [ go-run-errand-1h ] }
                    { at 14.5 prob 0.75 tasks [ go-get-coffee ] }
                    { at 17 prob 0.5 tasks [ go-visit-retail ] }
                ]
            }

            ; office worker that will always want lunch, sometimes coffee and breakfast.
            {
                name "schedule-office.4"
                blocks [
                    { from 9 to 17 tasks [ go-work-at-workstation ] }
                    { from 17 to 9 tasks [ go-stay-offsite ] }
                ]
                oneshots [
                    { at 9 prob 0.75 tasks [ go-get-coffee ] }
                    { at 9 prob 0.5 tasks [ go-get-breakfast ] }
                    { at 12 prob 1 tasks [ go-get-lunch ] }
                    { at 14 prob 0.5 tasks [ go-get-vending ] }
                    { at 14.5 prob 0.75 tasks [ go-get-coffee ] }
                    { at 17 prob 0.5 tasks [ go-visit-retail ] }
                ]
            }

            ;always lunch, sometimes breakfast, coffee and dinner
            {
                name "schedule-office.5"
                blocks [
                    { from 10.5 to 19 tasks [ go-work-at-workstation ] }
                    { from 19 to 10.5 tasks [ go-stay-offsite ] }
                ]
                oneshots [
                    { at 10.5 prob 0.5 tasks [ go-get-coffee go-get-breakfast ] }
                    { at 14 prob 1 tasks [ go-get-lunch ] }
                    { at 16 prob 0.5 tasks [ go-get-vending ] }
                    { at 14 prob 0.25 tasks [ go-visit-retail ] }
                    { at 19 prob 0.5 tasks [ go-get-dinner ] }
                    { at 19 prob 0.5 tasks [ go-visit-retail ] }
                ]
            }

            ;; office worker that goes offsite in the afternoon (consultant)
            {
                name "schedule-office.6"
                blocks [
                    { from 8 to 10 tasks [ go-work-at-workstation ] }
                    { from 10 to 14 tasks [ go-stay-offsite ] }
                    { from 14 to 16 tasks [ go-work-at-workstation ] }
                    { from 16 to 8 tasks [ go-stay-offsite ] }
                ]
                oneshots [
                    { at 8 prob 0.5 tasks [ go-get-breakfast ] }
                    { at 12 prob 0.5 tasks [ go-get-vending ] }
                    { at 14 prob 1 tasks [ go-get-lunch ] }
                    { at 14 prob 0.25 tasks [ go-visit-retail ] }
                    { at 16 prob 0.5 tasks [ go-get-coffee ] }
                    { at 16 prob 0.5 tasks [ go-visit-retail ] }
                ]
            }
            ;; white collar - stockbroker/legal with long hours.
            {
                name "schedule-office.7"
                blocks [
                    { from 8 to 20 tasks [ go-work-at-workstation ] }
                    { from 20 to 8 tasks [ go-stay-offsite ] }
                ]
                oneshots [
                    { at 8 prob 1 tasks [ go-get-coffee ] }
                    { at 12 prob 1 tasks [ go-get-lunch ] }
                    { at 12 prob 0.25 tasks [ go-visit-retail ] }
                    { at 14 prob 1 tasks [ go-get-vending ] }
                    { at 15 prob 0.5 tasks [ go-get-coffee ] }
                    { at 17.5 prob 0.5 tasks [ go-visit-retail ] }
                    { at 18 prob 0.5 tasks [ go-get-vending ] }
                    { at 20 prob 0.5 tasks [ go-get-dinner ] }
                    { at 20 prob 0.25 tasks [ go-get-drink ] }
                ]
            }

            ;; regional manager type office worker
            {
                name "schedule-office.8"
                blocks [
                    { from 9 to 17 tasks [ go-work-at-workstation ] }
                    { from 17 to 9 tasks [ go-stay-offsite ] }
                ]
                oneshots [
                    { at 9 prob 1 tasks [ go-get-breakfast ] }
                    { at 10.5 prob 0.5 tasks [ go-run-errand-1h ] }
                    { at 12.5 prob 1 tasks [ go-get-lunch ] }
                    { at 12.5 prob 0.25 tasks [ go-visit-retail ] }
                    { at 14.5 prob 0.5 tasks [ go-get-vending ] }
                    { at 15 prob 0.5 tasks [ go-run-errand-1h ] }
                    { at 17 prob 0.5 tasks [ go-get-dinner ] }
                    { at 17 prob 0.5 tasks [ go-visit-retail ] }
                    { at 17 prob 0.25 tasks [ go-get-drink ] }
                ]
            }

            ; in late, out late, dinner break

            {
                name "schedule-office.9"
                blocks [
                    { from 11 to 21 tasks [ go-work-at-workstation ] }
                    { from 21 to 11 tasks [ go-stay-offsite ] }
                ]
                oneshots [
                    { at 11 prob 0.5 tasks [ go-get-lunch ] }
                    { at 14 prob 0.5 tasks [ go-get-vending ] }
                    { at 15 prob 0.5 tasks [ go-get-coffee ] }
                    { at 15 prob 0.25 tasks [ go-visit-retail ] }
                    { at 18.5 prob 1 tasks [ go-get-dinner ] }
                ]
            }

            ;; night office worker - radio, etc.
            {
                name "schedule-office.10"
                blocks [
                    { from 0 to 9 tasks [ go-work-at-workstation ] }
                    { from 9 to 0 tasks [ go-stay-offsite ] }
                ]
                oneshots [
                    { at 9 prob 0.74 tasks [ go-get-breakfast ] }
                    { at 3 prob 0.5 tasks [ go-get-vending ] }
                ]
            }

            ;; doctor
            {
                name "schedule-office.doctor.1"
                blocks [
                    { from 8.5 to 18 tasks [ go-work-at-workstation ] }
                    { from 18 to 8.5 tasks [ go-stay-offsite ] }
                ]
                oneshots [
                    { at 8.5 prob 0.5 tasks [ go-get-breakfast ] }
                    { at 10 prob 0.25 tasks [ go-run-errand-1h ] }
                    { at 12.5 prob 0.5 tasks [ go-get-lunch ] }
                    { at 12.5 prob 0.25 tasks [ go-visit-retail ] }
                    { at 14.5 prob 0.25 tasks [ go-run-errand-1h ] }
                    { at 17 prob 0.25 tasks [ go-run-errand-1h ] }
                    { at 17 prob 0.5 tasks [ go-visit-retail ] }
                ]
            }
            {
                name "schedule-office.doctor.2"
                blocks [
                    { from 7 to 11 tasks [ go-work-at-workstation ] }
                    { from 11 to 15 tasks [ go-stay-offsite ] }
                    { from 15 to 18.5 tasks [ go-work-at-workstation ] }
                    { from 18.5 to 7 tasks [ go-stay-offsite ] }
                ]
                oneshots [
                    { at 7 prob 0.5 tasks [ go-get-breakfast ] }
                    { at 11 prob 1 tasks [ go-get-lunch ] }
                    { at 11 prob 0.25 tasks [ go-visit-retail ] }
                    { at 15 prob 0.5 tasks [ go-get-coffee ] }
                    { at 18.5 prob 0.5 tasks [ go-get-dinner ] }
                    { at 18.5 prob 0.5 tasks [ go-visit-retail ] }
                ]
            }
            {
                name "schedule-office.admin.1"
                blocks [
                    { from 7.5 to 16 tasks [ go-work-at-workstation ] }
                    { from 16 to 7.5 tasks [ go-stay-offsite ] }
                ]
                oneshots [
                    { at 7.5 prob 0.5 tasks [ go-get-coffee ] }
                    { at 11.5 prob 1 tasks [ go-get-lunch ] }
                    { at 13 prob 0.25 tasks [ go-visit-retail ] }
                    { at 14 prob 0.25 tasks [ go-run-errand-2h ] }
                    { at 16 prob 0.5 tasks [ go-visit-retail ] }
                ]

            }

            ; tech office admin
            {
                name "schedule-office.admin.2"
                blocks [
                    { from 9.5 to 17.5 tasks [ go-work-at-workstation ] }
                    { from 17.5 to 9.5 tasks [ go-stay-offsite ] }
                ]
                oneshots [
                    { at 9.5 prob 1 tasks [ go-get-coffee ] }
                    { at 12.5 prob 1 tasks [ go-get-lunch ] }
                    { at 12.5 prob 0.25 tasks [ go-visit-retail ] }
                    { at 15 prob 1 tasks [ go-get-coffee ] }
                    { at 17.5 prob 0.5 tasks [ go-visit-retail ] }
                    { at 17.5 prob 0.25 tasks [ go-get-drink ] }
                ]

            }
             ;; meeting attendeees - afternoon
            {
                name "schedule-office.meeting.1"
                blocks [
                    { from 12.5 to 16.5 tasks [ go-work-at-workstation ] }
                    { from 16.5 to 12.5 tasks [ go-stay-offsite ] }
                ]
                oneshots [
                    { at 12.5 prob 0.5 tasks [ go-get-coffee ] }
                    { at 16.5 prob 0.5 tasks [ go-get-coffee ] }
                    { at 16.5 prob 0.25 tasks [ go-visit-retail ] }
                ]
            } 
             ;; meeting attendeees - morning
            {
                name "schedule-office.meeting.2"
                blocks [
                    { from 8.5 to 11.5 tasks [ go-work-at-workstation ] }
                    { from 11.5 to 8.5 tasks [ go-stay-offsite ] }
                ]
                oneshots [
                    { at 8.5 prob 0.5 tasks [ go-get-coffee ] }
                    { at 11.5 prob 0.5 tasks [ go-get-coffee ] }
                    { at 11.5 prob 0.25 tasks [ go-visit-retail ] }
                ]
            } 



            ;;;;;; service workers

            {   name "schedule-service-delivery"
                blocks [
                    { from  7 to  8 tasks [ go-work-at-workstation ] }
                    { from  8 to 18 tasks [ go-work-tasks ] }
                    { from 18 to 18.5 tasks [ go-work-at-workstation ] }
                    { from 18.5 to 7 tasks [ go-stay-offsite ] }
                ]
                oneshots [
                    { at 7 prob 0.5 tasks [ go-get-breakfast ] }
                    { at 13 prob 1.0 tasks [ go-get-lunch ] }
                    { at 18.5 prob 0.5 tasks [ go-visit-retail ] }
                ]
            }
            {
                name "schedule-service-items"
                blocks [
                    { from 9 to 10 tasks [ go-work-at-workstation ] }
                    { from 10 to 18 tasks [ go-work-tasks ] }
                    { from 18 to 19 tasks [ go-work-at-workstation ] }
                    { from 19 to 9 tasks [ go-stay-offsite ] }
                ]
                oneshots [
                    { at 9 prob 0.5 tasks [ go-get-coffee ] }
                    { at 14 prob 1 tasks [ go-get-lunch ] }
                    { at 19 prob 0.5 tasks [ go-get-dinner ] }
                    { at 19 prob 0.5 tasks [ go-visit-retail ] }
                ]
            }
            {
                name "schedule-service-cleaning-night"
                blocks [
                    { from 20 to 21 tasks [ go-work-at-workstation ] }
                    { from 21 to 1 tasks [ go-work-tasks ] }
                    { from 1 to 2 tasks [ go-work-at-workstation ] }
                    { from 2 to 5 tasks [ go-work-tasks ] }
                    { from 5 to 5.5 tasks [ go-work-at-workstation ] }
                    { from 5.5 to 20 tasks [ go-stay-offsite ] }
                ]
                oneshots [
                    { at 8 prob 0.5 tasks [ go-get-breakfast ] }
                ]
            }
            {
                name "schedule-service-residences-day"
                blocks [
                    { from 8 to 9 tasks [ go-work-at-workstation ] }
                    { from 9 to 16 tasks [ go-work-tasks ] }
                    { from 16 to 17 tasks [ go-work-at-workstation ] }
                    { from 17 to 8 tasks [ go-stay-offsite ] }
                ]
                oneshots[
                    { at 8 prob 0.5 tasks [ go-get-coffee ] }
                    { at 12 prob 1 tasks [ go-get-lunch ] }
                    { at 14.5 prob 0.5 tasks [ go-get-coffee ] }
                    { at 17 prob 0.5 tasks [ go-visit-retail ] }
                ]
            }
            {
                name "schedule-service-equipment"
                blocks [
                    { from 8 to 9 tasks [ go-work-at-workstation ] }
                    { from 9 to 12 tasks [ go-work-tasks ] }
                    { from 12 to 13.5 tasks [ go-work-at-workstation ] }
                    { from 13.5 to 16 tasks [ go-work-tasks ] }
                    { from 16 to 17 tasks [ go-work-at-workstation ] }
                    { from 17 to 8 tasks [ go-stay-offsite ] }
                ]
                oneshots [
                    { at 9 prob 0.5 tasks [ go-get-coffee ] }
                    { at 12.5 prob 1 tasks [ go-get-lunch ] }
                    { at 17 prob 0.25 tasks [ go-get-dinner ] }
                    { at 17 prob 0.5 tasks [ go-visit-retail ] }
                ]
            }
            {
                name "schedule-service-catering"
                blocks [
                    { from 6 to 8 tasks [ go-work-at-workstation ] }
                    { from 8 to 16 tasks [ go-work-tasks ] }
                    { from 16 to 17 tasks [ go-work-at-workstation ] }
                    { from 17 to 6 tasks [ go-stay-offsite ] }
                ]
                oneshots [
                    { at 6 prob 0.25 tasks [ go-get-breakfast ] }
                    { at 17 prob 0.5 tasks [ go-get-coffee ] }
                    { at 17 prob 0.5 tasks [ go-visit-retail ] }
                ]
            }
            {
                name "schedule-service-repair"
                blocks [
                    { from 6 to 7 tasks [ go-work-at-workstation ] }
                    { from 7 to 15.5 tasks [ go-work-tasks ] }
                    { from 15.5 to 16.5 tasks [ go-work-at-workstation ] }
                    { from 16.5 to 6 tasks [ go-stay-offsite ] }
                ]
                oneshots [
                    { at 6 prob 0.5 tasks [ go-get-coffee ] }
                    { at 12 prob 1 tasks [ go-get-lunch ] }
                    { at 16.5 prob 0.5 tasks [ go-get-coffee ] }
                    { at 16.5 prob 0.5 tasks [ go-visit-retail ] }
                ]
            }
            {
                name "schedule-service-laundry"
                blocks [
                    { from 8 to 9 tasks [ go-work-at-workstation ] }
                    { from 9 to 16 tasks [ go-work-tasks ] }
                    { from 16 to 17 tasks [ go-work-at-workstation ] }
                    { from 17 to 8 tasks [ go-stay-offsite ] }
                ]
                oneshots [
                    { at 12 prob 0.5 tasks [ go-get-lunch ] }
                    { at 17 prob 0.5 tasks [ go-visit-retail ] }
                ]
            }
            {
                name "schedule-service-whitecollar"
                blocks [
                    { from 8 to 9 tasks [ go-work-at-workstation ] }
                    { from 9 to 16 tasks [ go-work-tasks ] }
                    { from 16 to 17 tasks [ go-work-at-workstation ] }
                    { from 17 to 8 tasks [ go-stay-offsite ] }
                ]
                oneshots[
                    { at 8 prob 0.5 tasks [ go-get-coffee ] }
                    { at 8 prob 0.5 tasks [ go-get-breakfast ] }
                    { at 12 prob 1 tasks [ go-get-lunch ] }
                    { at 14.5 prob 0.5 tasks [ go-get-coffee ] }
                    { at 17 prob 0.5 tasks [ go-get-dinner ] }
                    { at 17 prob 0.25 tasks [ go-get-drink ] }
                    { at 17 prob 0.5 tasks [ go-visit-retail ] }
                ]
            }
            {
                name "schedule-service-club"
                blocks [
                    { from 13 to 21 tasks [ go-work-at-workstation ] }
                    { from 21 to 13 tasks [ go-stay-offsite ] }
                ]
                oneshots [
                    { at 13 prob 0.5 tasks [ go-get-coffee ] }
                    { at 17 prob 0.5 tasks [ go-get-dinner ] }
                ]
            }
            {
                name "schedule-service-highend-res"
                blocks [
                    { from 9 to 10 tasks [ go-work-at-workstation ] }
                    { from 10 to 16 tasks [ go-work-tasks ] }
                    { from 16 to 17.5 tasks [ go-work-at-workstation ] }
                    { from 17.5 to 9 tasks [ go-stay-offsite ] }
                ]
                oneshots [
                    { at 9 prob 0.75 tasks [ go-get-coffee ] }
                    { at 13 prob 1 tasks [ go-get-lunch ] }
                    { at 17.5 prob 0.5 tasks [ go-visit-retail ] }
                    { at 17.5 prob 0.5 tasks [ go-get-dinner ] }
                ]
            }



            ;;;;;; bulding staff

            {
                name "schedule-maintenance-1"
                blocks [
                    { from 0 to 0 tasks [ go-work-tasks ] }
                ]
                oneshots [
                    { at 8 prob 0.5 tasks [ go-get-breakfast ] }
                    { at 11 prob 0.5 tasks [ go-get-coffee ] }
                    { at 13.5 prob 1 tasks [ go-get-lunch ] }
                    { at 17 prob 0.5 tasks [ go-get-dinner ] }
                ]
            }
            {
                name "schedule-maintenance-2"
                blocks [
                    { from 0 to 0 tasks [ go-work-tasks ] }
                ]
                oneshots [
                    { at 7 prob 0.5 tasks [ go-get-breakfast ] }
                    { at 10 prob 0.5 tasks [ go-get-coffee ] }
                    { at 12 prob 1 tasks [ go-get-lunch ] }
                    { at 17 prob 0.5 tasks [ go-get-dinner ] }
                ]
            }
            {
                name "schedule-garbage"
                blocks [
                    { from 6 to 18 tasks [ go-work-tasks ] }
                    { from 18 to 6 tasks [ go-stay-offsite ] }
                ]
                oneshots [
                    { at 7 prob 0.5 tasks [ go-get-breakfast ] }
                    { at 10 prob 0.5 tasks [ go-get-coffee ] }
                    { at 12 prob 1 tasks [ go-get-lunch ] }
                ]
            }
            {
                name "schedule-loading-dock"
                blocks [
                    { from 7 to 15 tasks [ go-work-at-workstation ] }
                    { from 15 to 16 tasks [ go-stay-offsite ] }
                    { from 16 to 0 tasks [ go-work-at-workstation ] }
                    { from 0 to 1 tasks [ go-stay-offsite ] }
                    { from 1 to 6 tasks [ go-work-at-workstation ] }
                    { from 6 to 7 tasks [ go-stay-offsite ] }
                ]
                oneshots [
                    { at 7 prob 0.5 tasks [ go-get-breakfast ] }
                    { at 10 prob 0.5 tasks [ go-get-coffee ] }
                    { at 12 prob 1 tasks [ go-get-lunch ] }
                    { at 17 prob 0.5 tasks [ go-get-dinner ] }
                ]
            }
            {
                name "schedule-construction-1"
                blocks [
                    { from 0 to 0 tasks [ go-work-tasks ] }
                ]
                oneshots [
                    { at 8 prob 0.5 tasks [ go-get-breakfast ] }
                    { at 10.5 prob 0.5 tasks [ go-get-coffee ] }
                    { at 13.5 prob 1 tasks [ go-get-lunch ] }
                    { at 18 prob 0.5 tasks [ go-get-dinner ] }
                ]
            }
            {
                name "schedule-construction-2"
                blocks [
                    { from 0 to 0 tasks [ go-work-tasks ] }
                ]
                oneshots [
                    { at 10 prob 0.5 tasks [ go-get-breakfast ] }
                    { at 17 prob 0.5 tasks [ go-get-coffee ] }
                    { at 14 prob 1 tasks [ go-get-lunch ] }
                    { at 20 prob 0.5 tasks [ go-get-dinner ] }
                ]
            }
            {
                name "schedule-metro-1"
                blocks [
                    { from 0 to 6 tasks [ go-work-at-workstation ] }
                    { from 6 to 0 tasks [ go-stay-offsite ] }
                ]
                oneshots [
                ]
            }
            {
                name "schedule-metro-2"
                blocks [
                    { from 6 to 12 tasks [ go-work-at-workstation ] }
                    { from 12 to 6 tasks [ go-stay-offsite ] }
                ]
                oneshots [
                ]
            }
            {
                name "schedule-metro-3"
                blocks [
                    { from 12 to 16 tasks [ go-work-at-workstation ] }
                    { from 16 to 12 tasks [ go-stay-offsite ] }
                ]
                oneshots [
                ]
            }
            {
                name "schedule-metro-4"
                blocks [
                    { from 16 to 0 tasks [ go-work-at-workstation ] }
                    { from 0 to 16 tasks [ go-stay-offsite ] }
                ]
                oneshots [
                ]
            }

            ;;;;;;;;;;;;;;;;;; restaurant workers
            {
                name "schedule-rest.morning"
                blocks [
                    { from 4.5 to 12.5 tasks [ go-work-at-workstation ] }
                    { from 12.5 to 20 tasks [ go-putter-at-home ] }
                    { from 20 to 3.5 tasks [ go-sleep-at-home ] }
                    { from 3.5 to 4.5 tasks [ go-putter-at-home ] }
                ]
                oneshots [
                    { at 8 prob 0.5 tasks [ go-get-breakfast ] }
                    { at 12.5 prob 0.5 tasks [ go-get-coffee ] }
                    { at 12.5 prob 0.5 tasks [ go-visit-retail ] }
                ]
            }
            {
                name "schedule-rest.brunch"
                blocks [
                    { from 6 to 14 tasks [ go-work-at-workstation ] }
                    { from 14 to 6 tasks [ go-stay-offsite ] }
                ]
                oneshots [
                    { at 8 prob 0.5 tasks [ go-get-breakfast ] }
                    { at 12.5 prob 0.5 tasks [ go-get-lunch ] }
                    { at 14 prob 0.5 tasks [ go-visit-retail ] }
                ]
            }
            {
                name "schedule-rest.day"
                blocks [
                    { from 10 to 18 tasks [ go-work-at-workstation ] }
                    { from 18 to 10 tasks [ go-stay-offsite ] }
                ]
                oneshots [
                    { at 15 prob 0.25 tasks [ go-get-lunch ] }
                    { at 17.5 prob 0.25 tasks [ go-get-dinner ] }
                    { at 18 prob 0.5 tasks [ go-visit-retail ] }
                ]
            }
            {
                name "schedule-rest.evening"
                blocks [
                    { from 15 to 23 tasks [ go-work-at-workstation ] }
                    { from 23 to 15 tasks [ go-stay-offsite ] }
                ]
                oneshots [
                    { at 22 prob 0.5 tasks [ go-get-dinner ] }
                ]
            }
            {
                name "schedule-rest.night"
                blocks [
                    { from 22 to 5 tasks [ go-work-at-workstation ] }
                    { from 5 to 22 tasks [ go-stay-offsite ] }
                ]
                oneshots [
                    { at 5 prob 0.5 tasks [ go-get-breakfast go-get-coffee ] }
                    { at 22.5 prob 0.25 tasks [ go-get-dinner ] }
                ]
            }
            {
                name "schedule-rest.host"
                blocks [
                    { from 11 to 19 tasks [ go-work-at-workstation ] }
                    { from 19 to 11 tasks [ go-stay-offsite ] }
                ]
                oneshots [
                    { at 15 prob 0.5 tasks [ go-get-lunch ] }
                    { at 19 prob 0.5 tasks [ go-visit-retail ] }
                ]
            }

            ;;;;;;;;;;;;;;;;;; retail workers
            {
                name "schedule-retail.day"
                blocks [
                    { from 9 to 19 tasks [ go-work-at-workstation ] }
                    { from 18 to 9 tasks [ go-stay-offsite ] }
                ]
                oneshots [
                    { at 13 prob 0.5 tasks [ go-get-lunch ] }
                    { at 18 prob 0.25 tasks [ go-get-dinner ] }
                    { at 19 prob 0.5 tasks [ go-visit-retail ] }
                ]
            }
            {
                name "schedule-retail.day2"
                blocks [
                    { from 9.5 to 20.5 tasks [ go-work-at-workstation ] }
                    { from 20.5 to 9.5 tasks [ go-stay-offsite ] }
                ]
                oneshots [
                    { at 14 prob 0.5 tasks [ go-get-lunch ] }
                    { at 20.5 prob 0.25 tasks [ go-get-dinner ] }
                    { at 20.5 prob 0.5 tasks [ go-visit-retail ] }
                ]
            }
            {
                name "schedule-retail.day3"
                blocks [
                    { from 11 to 18 tasks [ go-work-at-workstation ] }
                    { from 18 to 11 tasks [ go-stay-offsite ]  }
                ]
                oneshots [
                    { at 11 prob 0.5 tasks [ go-get-coffee ] }
                    { at 13 prob 0.5 tasks [ go-get-lunch ] }
                    { at 18 prob 0.5 tasks [ go-get-dinner ] }
                    { at 18 prob 0.5 tasks [ go-visit-retail ] }
                ]
            }
            ;;;;;;;;;;;;;;;;;;; resident-only

            ;; stay at homes
            {
                name "schedule-resident-stayathomeparent"
                blocks [
                    { from 7 to 22 tasks [ go-putter-at-home ] }
                    { from 22 to 7 tasks [ go-sleep-at-home ] }
                ]
                oneshots [
                    { at 8 prob 0.25 tasks [ go-get-breakfast go-get-coffee ] }
                    { at 9.5 prob 0.5 tasks [ go-run-errand-2h ] }
                    { at 13 prob 0.25 tasks [ go-get-lunch ] }
                    { at 13 prob 0.25 tasks [ go-visit-retail ] }
                    { at 14 prob 0.5 tasks [ go-visit-retail ] }
                    { at 15 prob 0.5 tasks [ go-run-errand-1h ] }
                    { at 18 prob 0.25 tasks [ go-get-dinner ] }
                    { at 19 prob 0.5 tasks [ go-get-vending ] }
                ]
            }
            {
                name "schedule-resident-stayathomespouse"
                blocks [
                    { from 7 to 22 tasks [ go-putter-at-home ] }
                    { from 22 to 7 tasks [ go-sleep-at-home ] }
                ]
                oneshots [
                    { at 8 prob 0.25 tasks [ go-get-breakfast go-get-coffee ] }
                    { at 9.5 prob 0.5 tasks [ go-run-errand-2h ] }
                    { at 12 prob 0.5 tasks [ go-get-vending ] }
                    { at 13 prob 0.25 tasks [ go-get-lunch ] }
                    { at 13 prob 0.25 tasks [ go-visit-retail ] }
                    { at 14 prob 0.5 tasks [ go-visit-retail ] }
                    { at 15 prob 0.5 tasks [ go-run-errand-1h ] }
                    { at 18 prob 0.25 tasks [ go-get-dinner ] }
                ]
            }
            {
                name "schedule-resident-retiree"
                blocks [
                    { from 6 to 21 tasks [ go-putter-at-home ] }
                    { from 21 to 6 tasks [ go-sleep-at-home ] }
                ]
                oneshots [
                    { at 7 prob 0.75 tasks [ go-get-breakfast ] }
                    { at 7 prob 0.25  tasks [ go-get-coffee ] }
                    { at 9 prob 0.5 tasks [ go-run-errand-2h ] }
                    { at 11 prob 0.25 tasks [ go-get-lunch ] }
                    { at 11 prob 0.25 tasks [ go-visit-retail ] }
                    { at 13.5 prob 0.5 tasks [ go-visit-retail ] }
                    { at 16.5 prob 0.25 tasks [ go-get-dinner ] }
                    { at 20 prob 0.5 tasks [ go-get-vending ] }
                ]
            }
            {
                name "schedule-resident-retiree-low"
                blocks [
                    { from 6 to 21 tasks [ go-putter-at-home ] }
                    { from 21 to 6 tasks [ go-sleep-at-home ] }
                ]
                oneshots [
                    { at 7 prob 0.75 tasks [ go-get-breakfast ] }
                    { at 7 prob 0.25  tasks [ go-get-coffee ] }
                    { at 9 prob 0.5 tasks [ go-run-errand-2h ] }
                    { at 11 prob 0.25 tasks [ go-get-lunch ] }
                    { at 13.5 prob 0.5 tasks [ go-visit-retail ] }
                    { at 16 prob 0.5 tasks [ go-get-vending ] }
                ]
            }
            {
                name "schedule-resident-student"
                blocks [
                    { from 9 to 10 tasks [ go-putter-at-home ] }
                    { from 10 to 12.5 tasks [ go-stay-offsite ] }
                    { from 12.5 to 17 tasks [ go-putter-at-home ] }
                    { from 17 to 20.5 tasks [ go-stay-offsite ] }
                    { from 20.5 to 23 tasks [ go-putter-at-home ] }
                    { from 23 to 9 tasks [ go-sleep-at-home ] }
                ]
                oneshots [
                    { at 10 prob 0.5 tasks [ go-get-coffee ] }
                    { at 12.5 prob 0.25 tasks [ go-get-lunch ] }
                    { at 12.5 prob 0.25 tasks [ go-visit-retail ] }
                    { at 15 prob 0.5 tasks [ go-get-coffee ] }
                    { at 15 prob 0.5 tasks [ go-run-errand-1h ] }
                    { at 16.5 prob 0.5 tasks [ go-visit-retail ] }
                    { at 21 prob 0.5 tasks [ go-get-vending ] }
                ]
            }
            {
                name "schedule-resident-worksathome"
                blocks [
                    { from 8 to 10 tasks [ go-putter-at-home ] }
                    { from 10 to 19 tasks [ go-putter-at-home ] } 
                    { from 19 to 0 tasks [ go-putter-at-home ] }
                    { from 0 to 8 tasks [ go-sleep-at-home ] }
                ]
                oneshots [
                    { at 10 prob 0.5 tasks [ go-get-coffee ] }
                    { at 10 prob 0.25 tasks [ go-get-breakfast ] }
                    { at 13 prob 0.25 tasks [ go-get-lunch ] }
                    { at 13 prob 0.25 tasks [ go-visit-retail ] }
                    { at 16 prob 0.1 tasks [ go-run-errand-2h ] }
                    { at 19 prob 0.5 tasks [ go-visit-retail ] }
                    { at 20.5 prob 0.25 tasks [ go-get-dinner ] }
                    { at 22 prob 0.5 tasks [ go-get-vending ] }
                ]
            }
            {
                name "schedule-kids"
                blocks [
                    { from 9 to 15 tasks [ go-stay-offsite ] }
                    { from 15 to 20 tasks [ go-putter-at-home ] }
                    { from 20 to 7 tasks [ go-sleep-at-home ] }
                    { from 7 to 9 tasks [ go-putter-at-home ] }
                ]
                oneshots [
                ]
            }

            ;; offsite workers
            {
                name "schedule-resident-worker-10am"
                blocks [
                    { from 10 to 18 tasks [ go-stay-offsite ] }
                    { from 18 to 23 tasks [ go-putter-at-home ] }
                    { from 23 to 8 tasks [ go-sleep-at-home ] }
                    { from 8 to 10 tasks [ go-putter-at-home ] }
                ]
                oneshots [
                    { at 10 prob 0.5 tasks [ go-get-coffee ] }
                    { at 10 prob 0.25 tasks [ go-get-breakfast ] }
                    { at 18 prob 0.5 tasks [ go-visit-retail ] }
                    { at 19 prob 0.25 tasks [ go-get-dinner ] }
                    { at 21 prob 0.5 tasks [ go-get-vending ] }
                ]
            }
            {
                name "schedule-resident-worker-9am"
                blocks [
                    { from 9 to 17 tasks [ go-stay-offsite ] }
                    { from 17 to 22 tasks [ go-putter-at-home ] }
                    { from 22 to 7 tasks [ go-sleep-at-home ] }
                    { from 7 to 9 tasks [ go-putter-at-home ] }
                ]
                oneshots [
                    { at 9 prob 0.5 tasks [ go-get-coffee ] }
                    { at 9 prob 0.25 tasks [ go-get-breakfast ] }
                    { at 17 prob 0.5 tasks [ go-visit-retail ] }
                    { at 18 prob 0.25 tasks [ go-get-dinner ] }
                    { at 20.5 prob 0.5 tasks [ go-get-vending ] }
                ]
            }
            {
                name "schedule-resident-worker-830am"
                blocks [
                    { from 8.5 to 16.5 tasks [ go-stay-offsite ] }
                    { from 16.5 to 22 tasks [ go-putter-at-home ] }
                    { from 22 to 6.5 tasks [ go-sleep-at-home ] }
                    { from 6.5 to 8.5 tasks [ go-putter-at-home ] }
                ]
                oneshots [
                    { at 8.5 prob 0.5 tasks [ go-get-coffee ] }
                    { at 8.5 prob 0.25 tasks [ go-get-breakfast ] }
                    { at 16.5 prob 0.5 tasks [ go-visit-retail ] }
                    { at 19 prob 0.25 tasks [ go-get-dinner ] }
                    { at 20 prob 0.5 tasks [ go-get-vending ] }
                ]
            }
            {
                name "schedule-resident-worker-8am"
                blocks [
                    { from 8 to 20 tasks [ go-stay-offsite ] }
                    { from 20 to 23 tasks [ go-putter-at-home ] }
                    { from 23 to 7 tasks [ go-sleep-at-home ] }
                    { from 7 to 8 tasks [ go-putter-at-home ] }
                ]
                oneshots [
                    { at 8 prob 0.5 tasks [ go-get-coffee ] }
                    { at 8 prob 0.25 tasks [ go-get-breakfast ] }
                    { at 20 prob 0.5 tasks [ go-visit-retail ] }
                    { at 21 prob 0.25 tasks [ go-get-dinner ] }
                    { at 22 prob 0.5 tasks [ go-get-vending ] }
                ]
            }
            {
                name "scheudle-resident-worker-11am"
                blocks [
                    { from 11 to 21 tasks [ go-stay-offsite ] }
                    { from 21 to 0 tasks [ go-putter-at-home ] }
                    { from 0 to 8 tasks [ go-sleep-at-home ] }
                    { from 8 to 11 tasks [ go-putter-at-home ] }
                ]
                oneshots [
                    { at 10 prob 0.5 tasks [ go-visit-retail ] }
                    { at 10 prob 0.25 tasks [ go-get-breakfast ] }
                    { at 11 prob 0.5 tasks [ go-get-coffee ] }
                    { at 21 prob 0.25 tasks [ go-get-dinner ] }
                    { at 23 prob 0.5 tasks [ go-get-vending ] }
                ]
            }

            {
                name "schedule-resident-worker-10am-low"
                blocks [
                    { from 10 to 18 tasks [ go-stay-offsite ] }
                    { from 18 to 23 tasks [ go-putter-at-home ] }
                    { from 23 to 8 tasks [ go-sleep-at-home ] }
                    { from 8 to 10 tasks [ go-putter-at-home ] }
                ]
                oneshots [
                    { at 10 prob 0.5 tasks [ go-get-coffee ] }
                    { at 10 prob 0.25 tasks [ go-get-breakfast ] }
                    { at 18 prob 0.5 tasks [ go-visit-retail ] }
                    { at 19 prob 0.25 tasks [ go-get-dinner ] }
                    { at 21.5 prob 0.5 tasks [ go-get-vending ] }
                ]
            }
            {
                name "schedule-resident-worker-9am-low"
                blocks [
                    { from 9 to 17 tasks [ go-stay-offsite ] }
                    { from 17 to 22 tasks [ go-putter-at-home ] }
                    { from 22 to 7 tasks [ go-sleep-at-home ] }
                    { from 7 to 9 tasks [ go-putter-at-home ] }
                ]
                oneshots [
                    { at 9 prob 0.5 tasks [ go-get-coffee ] }
                    { at 9 prob 0.25 tasks [ go-get-breakfast ] }
                    { at 17 prob 0.5 tasks [ go-visit-retail ] }
                    { at 19 prob 0.5 tasks [ go-get-vending ] }
                ]
            }
            {
                name "schedule-resident-worker-830am-low"
                blocks [
                    { from 8.5 to 16.5 tasks [ go-stay-offsite ] }
                    { from 16.5 to 22 tasks [ go-putter-at-home ] }
                    { from 22 to 6.5 tasks [ go-sleep-at-home ] }
                    { from 6.5 to 8.5 tasks [ go-putter-at-home ] }
                ]
                oneshots [
                    { at 8.5 prob 0.5 tasks [ go-get-coffee ] }
                    { at 8.5 prob 0.25 tasks [ go-get-breakfast ] }
                    { at 16.5 prob 0.5 tasks [ go-visit-retail ] }
                    { at 19.5 prob 0.5 tasks [ go-get-vending ] }
                ]
            }
            {
                name "schedule-resident-worker-8am-low"
                blocks [
                    { from 8 to 20 tasks [ go-stay-offsite ] }
                    { from 20 to 23 tasks [ go-putter-at-home ] }
                    { from 23 to 7 tasks [ go-sleep-at-home ] }
                    { from 7 to 8 tasks [ go-putter-at-home ] }
                ]
                oneshots [
                    { at 8 prob 0.5 tasks [ go-get-coffee ] }
                    { at 8 prob 0.25 tasks [ go-get-breakfast ] }
                    { at 20 prob 0.5 tasks [ go-visit-retail ] }
                    { at 21.5 prob 0.5 tasks [ go-get-vending ] }
                ]
            }
            {
                name "scheudle-resident-worker-11am-low"
                blocks [
                    { from 11 to 21 tasks [ go-stay-offsite ] }
                    { from 21 to 0 tasks [ go-putter-at-home ] }
                    { from 0 to 8 tasks [ go-sleep-at-home ] }
                    { from 8 to 11 tasks [ go-putter-at-home ] }
                ]
                oneshots [
                    { at 10 prob 0.5 tasks [ go-visit-retail ] }
                    { at 10 prob 0.25 tasks [ go-get-breakfast ] }
                    { at 11 prob 0.5 tasks [ go-get-coffee ] }
                    { at 22.5 prob 0.5 tasks [ go-get-vending ] }
                ]
            }

            ;; visitors

            {
                name "schedule-visitor-one"
                lifetime [
                    { prob 1.0 tasks [ go-visit-target ] }
                    { prob 0.25 tasks [ go-get-lunch ]  }
                    { prob 1.0 tasks [ go-end-visit ] }
                ]
            }
            {
                name "schedule-visitor-two"
                lifetime [
                    { prob 1.0 tasks [ go-visit-target ] }
                    { prob 0.25 tasks [ go-get-dinner ] }
                    { prob 1.0 tasks [ go-end-visit ] }
                ]
            }
            {
                name "schedule-visitor-three"
                lifetime [
                    { prob 1.0 tasks [ go-visit-target ] }
                    { prob 0.5 tasks [ go-visit-retail ] }
                    { prob 0.5 tasks [ go-get-lunch ]  }
                    { prob 1.0 tasks [ go-end-visit ] }
                ]
            }
            {
                name "schedule-visitor-four"
                lifetime [
                    { prob 1.0 tasks [ go-visit-target ] }
                    { prob 0.5 tasks [ go-get-dinner ] }
                    { prob 0.25 tasks [ go-get-drink ] }
                    { prob 1.0 tasks [ go-end-visit ] }
                ]
            }
            {
                name "schedule-visitor-restaurant-one"
                lifetime [
                    { prob 1.0 tasks [ go-visit-target ] }
                    { prob 0.25 tasks [ go-get-coffee ] }
                    { prob 0.5 tasks [ go-visit-retail ] }
                    { prob 1.0 tasks [ go-end-visit ] }
                ]

            }
            {
                name "schedule-visitor-restaurant-two"
                lifetime [
                    { prob 1.0 tasks [ go-visit-target ] }
                    { prob 0.25 tasks [ go-get-drink ] }
                    { prob 1.0 tasks [ go-end-visit ] }
                ]

            }
            {
                name "schedule-visitor-retail-and-maybe-lunch"
                lifetime [
                    { prob 1.0 tasks [ go-visit-target ] }
                    { prob 0.2 tasks [ go-get-lunch ] }
                    { prob 1.0 tasks [ go-end-visit ] }
                ]
            }
            {
                name "schedule-visitor-retail-and-maybe-coffee"
                lifetime [
                    { prob 1.0 tasks [ go-visit-target ] }
                    { prob 0.2 tasks [ go-get-coffee ] }
                    { prob 1.0 tasks [ go-end-visit ] }
                ]
            }
            {
                name "schedule-visitor-retail-and-maybe-coffee-more-shopping"
                lifetime [
                    { prob 1.0 tasks [ go-visit-target ] }
                    { prob 0.5 tasks [ go-get-coffee ] }
                    { prob 0.5 tasks [ go-visit-retail ] }
                    { prob 1.0 tasks [ go-end-visit ] }
                ]
            }
            {
                name "schedule-visitor-retail-lunch-more-shopping"
                lifetime [
                    { prob 1.0 tasks [ go-visit-target ] }
                    { prob 0.5 tasks [ go-visit-retail ] }
                    { prob 0.5 tasks [ go-get-coffee ] }
                    { prob 1.0 tasks [ go-end-visit ] }
                ]
            }
            {
                name "schedule-visitor-retail-and-maybe-dinner"
                lifetime [
                    { prob 1.0 tasks [ go-visit-target ] }
                    { prob 0.5 tasks [ go-get-dinner ] }
                    { prob 1.0 tasks [ go-end-visit ] }
                ]
            }
            {
                name "schedule-visitor-artpatron"
                lifetime [
                    { prob 1 tasks [ go-visit-target ] }
                    { prob 1 tasks [ go-get-coffee ] }
                    { prob 0.5 tasks [ go-get-lunch ] }
                    { prob 0.5 tasks [ go-visit-retail ] }
                    { prob 1 tasks [ go-end-visit ] }
                    ;add get a drink with high probability
                ]
            }

                ;;;;;;;;;;;;;;;; test/prototype visitors below. delete later.

            {
                name "schedule-visitor-office-and-maybe-lunch"
                lifetime [
                    { prob 1.0 tasks [ go-visit-target ] }
                    { prob 0.5 tasks [ go-get-lunch ] }
                    { prob 1.0 tasks [ go-end-visit ] }
                ]
            }
            {
                name "schedule-visitor-retail-and-maybe-lunch"
                lifetime [
                    { prob 1.0 tasks [ go-visit-retail ] }
                    { prob 0.2 tasks [ go-get-lunch ] }
                    { prob 1.0 tasks [ go-end-visit ] }
                ]
            }
            {
                name "schedule-visitor-civic"
                lifetime [
                    { prob 1.0 tasks [ go-visit-civic ] }
                    { prob 1.0 tasks [ go-end-visit ] }
                ]
            }

        ]
        taskdefaults [
            { task go-get-breakfast tags [ rest-type-breakfast ] }
            { task go-get-coffee tags [ rest-type-coffee ] }
            { task go-get-lunch tags [ rest-type-lunch ] }
            { task go-get-dinner tags [ rest-type-dinner ] }
            { task go-get-lunch tags [ rest-type-lunch ] }
            { task go-get-drink tags [ rest-type-bar ] }
            { task go-visit-retail tags [ retail ] }
        ]

        scripts [
            ;; failure scripts
            {   name    fail-go-home
                actions [
                    { #type action-set-on-failure handler #null }
                    { #type action-log-thought thought pathfailtohome }
                    { #type action-set-animation name peepunhappy }
                    { #type action-debug-text text "DBG can't go home" }
                    { #type action-pause gamehours 0.25 }
                ]
            }
            {   name    fail-go-work
                actions [
                    { #type action-set-on-failure handler #null }
                    { #type action-log-thought thought pathfailtowork }
                    { #type action-set-animation name peepunhappy }
                    { #type action-debug-text text "DBG can't go work" }
                    { #type action-pause gamehours 0.25 }
                ]
            }
            {   name    fail-go-task
                actions [
                    { #type action-set-on-failure handler #null }
                    { #type action-finish-task success #false } ;; important!
                    { #type action-log-thought thought pathfailtopoi }
                    { #type action-set-animation name peepunhappy }
                    { #type action-debug-text text "DBG can't get to task location" }
                    { #type action-pause gamehours 0.25 }
                ]
            }
            {   name    fail-go-to-restaurant
                actions [
                    { #type action-set-on-failure handler #null }
                    { #type action-clear-poi } ;; reset
                    { #type action-log-thought thought pathfailtopoi }
                    { #type action-set-animation name peepunhappy }
                    { #type action-debug-text text "DBG can't get to POI" } ;; todo: communicate this better
                    { #type action-pause gameminutes 10 }
                ]
            }
            {   name    fail-wait-in-line
                actions [
                    { #type action-set-on-failure handler #null }
                    { #type action-clear-poi } ;; reset
                    { #type action-log-thought thought foodtimeout valence -0.3 }
                    { #type action-set-animation name peepunhappy }
                    { #type action-debug-text text "DBG Abort queue. No food for me" }
                    { #type action-update-favorites action reset prob 0.1 } ;; !!!
                    { #type action-maybe-generate-buzz happy #false }
                    { #type action-pause gameminutes 10 }
                ]
            }
            {   name    fail-go-poi
                actions [
                    { #type action-set-on-failure handler #null }
                    { #type action-log-thought thought pathfailtopoi }
                    { #type action-set-animation name peepunhappy }
                    { #type action-debug-text text "DBG can't get to task location" }
                    { #type action-pause gamehours 0.25 }
                ]
            }
            {   name    fail-go-to-vending
                actions [
                    { #type action-set-on-failure handler #null } ;; don't do anything at all
                    { #type action-pause gamehours 0.1 }
                ]
            }
            {
                name    fail-go-visit
                actions [
                    { #type action-debug-text text "O, I die, Horatio!" }
                    { #type action-die }
                ]
            }
            {   name    fail-find-restaurant
                actions [
                    { #type action-set-on-failure handler #null }
                    { #type action-clear-poi } ;; reset where we're going
                    { #type action-log-task-thought valence -0.10 }
                    { #type action-set-animation name peepunhappy }
                    { #type action-debug-text text "DBG failed to find restaurant" } ;; todo: communicate this better
                    { #type action-pause gameminutes 10 }
                ]
            }
            {   name    fail-quietly
                actions [
                    { #type action-set-on-failure handler #null }
                    { #type action-set-animation name peepunhappy }
                    { #type action-debug-text text "DBG got nowhere to go" }
                    { #type action-pause gamehours 0.25 }
                ]
            }



            ;; go home scripts
            {   name    script-pause-offsite
                actions [
                    { #type action-change-visibility visible #false }
                    { #type action-set-animation name peepdefault } ;; important so we don't animate!
                    { #type action-pause gamehoursrange { from 0.9 to 1.1 } }
                ]
            }
            {   name    script-pause-onsite
                actions [
                    { #type action-set-animation name peepdefault } ;; important so we don't animate!
                    { #type action-pause gamehours 0.1 }
                ]
            }
            {   name    script-exit-and-sleep-offsite
                actions [
                    { #type action-set-on-failure handler fail-go-home }
                    { #type action-log-thought thought goinghome }

                    { #type action-set-target type boardexit }
                    { #type action-navigate }
                    { #type action-change-visibility visible #false }
                    { #type action-set-animation name peepdefault } ;; important so we don't animate!
                ]
            }

            {   name    script-go-home-onsite
                actions [
                    { #type action-set-on-failure handler fail-go-home }
                    { #type action-log-thought thought goinghome }

                    { #type action-change-apartment-reservation action set sleep #false gamehours 0.1 } ;; before set target, but it will expire immediately
                    { #type action-change-visibility visible #true }
                    { #type action-set-target type home xoffset { from -0.5 to 0.5 } }
                    { #type action-navigate }
                ]
            }
            {
                name    script-rest-at-home
                actions [
                    { #type action-change-apartment-reservation action set sleep #true gamehours 1 } ;; before set target
                    { #type action-set-target type home sleep #true }
                    { #type action-navigate }
                    { #type action-set-special-home-animation }
                    { #type action-pause gamehours 1 }
                    { #type action-change-apartment-reservation action clear }
                ]
            }
            {   name    script-putter-at-home
                actions [
                    { #type action-set-on-failure handler fail-go-home }
                    { #type action-change-visibility visible #true }

                    { #type action-change-apartment-reservation action set sleep #false gamehours 0.6 } ;; before set target
                    { #type action-set-target type home xoffset { from -1.5 to 1.5 } }
                    { #type action-navigate }
                    { #type action-set-special-home-animation }
                    { #type action-pause gamehours 0.6 }
                    { #type action-change-apartment-reservation action clear } ;; optional, they expire

                    { #type action-react-to-grime grimethreshold 0.3 probability 0.1 multiplier -0.4 }
                ]
            }

            ;; offsite errands

            {   name    script-exit-and-stay-offsite
                actions [
                    { #type action-set-on-failure handler fail-go-poi }
                    { #type action-set-target type boardexit }
                    { #type action-navigate }
                    { #type action-change-visibility visible #false }
                    { #type action-set-animation name peepdefault } ;; important so we don't animate!
                ]
            }
            {   name    script-exit-offsite-for-1h
                actions [
                    { #type action-set-on-failure handler fail-go-poi }
                    { #type action-set-target type boardexit }
                    { #type action-navigate }
                    { #type action-change-visibility visible #false }
                    { #type action-set-animation name peepdefault }
                    { #type action-pause gamehours 1 }
                ]
            }
            {   name    script-exit-offsite-for-2h
                actions [
                    { #type action-set-on-failure handler fail-go-poi }
                    { #type action-set-target type boardexit }
                    { #type action-navigate }
                    { #type action-change-visibility visible #false }
                    { #type action-set-animation name peepdefault }
                    { #type action-pause gamehours 2 }
                ]
            }


            ;; working onsite
            {
                name    script-exit-and-work-offsite
                actions [
                    { #type action-set-on-failure handler fail-go-work }
                    { #type action-log-thought thought goingtowork }

                    { #type action-set-target type boardexit }
                    { #type action-navigate }
                    { #type action-change-visibility visible #false }
                    { #type action-set-animation name peepdefault } ;; important so we don't animate!
                ]
            }
            {   name    script-go-to-workstation-onsite
                actions [
                    { #type action-set-on-failure handler fail-go-work }
                    { #type action-log-thought thought goingtowork }

                    { #type action-change-visibility visible #true }
                    { #type action-set-target type workplace xoffset { from -1.5 to 1.5 } }
                    { #type action-navigate }
                    { #type action-set-contextual-animation type workstation }
                    { #type action-pause gamehoursrange { from 0.4 to 0.5 } }
                ]
            }
            {
                name    script-do-work-at-workstation
                actions [
                    { #type action-set-contextual-animation type workstation }
                    { #type action-pause gamehoursrange { from 0.4 to 0.6 } }
                    { #type action-react-to-grime grimethreshold 0.3 probability 0.1 multiplier -0.4 }
                ]
            }
            {
                name    script-go-to-poi-and-wait
                actions [
                    { #type action-set-target type poi xoffset { from -0.5 to 0.5 } }
                    { #type action-navigate }
                    { #type action-set-animation name peepdefault }
                    { #type action-pause gamehours 0.1 }
                ]
            }

            ;; doing tasks
            {
                name    src-do-task-at-location
                actions [
                    { #type action-set-on-failure handler fail-go-task }
                    { #type action-change-visibility visible #true }
                    { #type action-set-target type task xoffset { from -0.5 to 0.5 } }
                    { #type action-navigate delivery #true }
                    { #type action-set-animation name peepdotask }
                    { #type action-pause-for-task }
                    { #type action-finish-task success #true }
                ]
            }


            ;; food!
            {
                name    script-go-to-sit-down-restaurant
                actions [
                    ;; we assume that poi id has already been set
                    { #type action-set-on-failure handler fail-go-to-restaurant }
                    { #type action-set-target type poi xoffset { from -1.5 to 1.5 } }
                    { #type action-navigate }

                    { #type action-set-on-failure handler fail-wait-in-line }
                    { #type action-set-target type currentunit }
                     { #type action-debug-text text "Enter queue" }
                    { #type action-wait-in-line animations [ peepstandl peepstandr ] }
                     { #type action-debug-text text "Leave queue" }

                    ;; this goes first before we clear poi - this could be our new favorite!
                    { #type action-update-favorites action tryset prob 0.2 }
                    { #type action-clear-poi } ;; reset
                    { #type action-log-task-thought valence 0.1 }

                     { #type action-debug-text text "Sit to nom" }
                    { #type action-set-target type currentunit }
                    { #type action-maybe-pay-for-visit }
                    { #type action-change-patron-reservation action set } 
                    { #type action-wait-seated fallbackanims [ peepeat ] }
                    { #type action-change-patron-reservation action clear } ;; optional, they also expire
                    { #type action-maybe-generate-buzz happy #true }
                     { #type action-debug-text text "Done nomming" }

                    { #type action-react-to-grime grimethreshold 0.3 probability 0.1 multiplier -0.4 }
                ]
            }
            {
                name    script-go-to-takeaway-restaurant
                actions [
                    ;; we assume that poi id has already been set
                    { #type action-set-on-failure handler fail-go-to-restaurant }
                    { #type action-set-target type poi xoffset { from -1.5 to 1.5 } }
                    { #type action-navigate }

                    ;; skip waiting in line

                    ;; this goes first before we clear poi - this could be our new favorite!
                    { #type action-update-favorites action tryset prob 0.2 }
                    { #type action-clear-poi } ;; reset
                    { #type action-log-task-thought valence 0.1 }

                     { #type action-debug-text text "Get takeaway" }
                    { #type action-maybe-pay-for-visit }
                ]
            }

            ;; visitors
            {
                name    script-go-visit-target
                actions [
                    { #type action-set-on-failure handler fail-go-visit }

                    ;; we assume that poi id has already been set
                    { #type action-set-target type poi xoffset { from -1.5 to 1.5 } }
                    { #type action-navigate }

                    { #type action-clear-poi } ;; reset
                    { #type action-set-animation name peepshop } ;; don't animate!
                    { #type action-pause gamehours 0.2 }
                    ;; { #type action-log-task-thought valence 0.1 } ;; todo later: affect happiness

                     { #type action-debug-text text "Visit target" }
                    { #type action-maybe-pay-for-visit }
                    { #type action-maybe-generate-buzz happy #true }
                    { #type action-react-to-grime grimethreshold 0.3 probability 0.1 multiplier -0.4 }
                ]
            }
            {
                name    script-go-visit-civic
                actions [
                    { #type action-set-on-failure handler fail-go-visit }

                    ;; we assume that poi id has already been set
                    { #type action-set-target type poi xoffset { from 1 to 1.5 } }
                    { #type action-navigate }

                    { #type action-clear-poi } ;; reset
                    { #type action-change-visibility visible #false }
                    { #type action-set-animation name peepdefault } ;; don't animate!
                    { #type action-pause gamehoursrange { from 1 to 2 } }
                    { #type action-change-visibility visible #true }

                     { #type action-debug-text text "Visit target" }
                ]
            }
            {
                name    script-go-visit-retail
                actions [
                    { #type action-set-on-failure handler fail-go-visit }

                    ;; we assume that poi id has already been set
                    { #type action-set-target type poi xoffset { from -0.5 to 0.5 } }
                    { #type action-navigate }

                    { #type action-clear-poi } ;; reset
                    { #type action-set-animation name peepshop }
                    { #type action-pause gamehours 0.2 }
                    ;; { #type action-log-task-thought valence 0.1 } ;; todo later: affect happiness

                     { #type action-debug-text text "Visit retail" }
                    { #type action-maybe-pay-for-visit }
                    { #type action-react-to-grime grimethreshold 0.3 probability 0.1 multiplier -0.4 }

                    { #type action-maybe-generate-buzz happy #true }
                ]
            }
            {
                name    script-go-to-vending
                actions [
                    { #type action-set-on-failure handler fail-go-to-vending }

                    ;; vending machine poi should be set by this point
                    { #type action-set-target type vending xoffset { from -0.5 to 0.5 } }
                    { #type action-navigate }
                    { #type action-clear-poi } ;; reset

                    { #type action-set-target type currentunit }
                    { #type action-change-patron-reservation action set } 
                    { #type action-set-special-vending-animation }
                    { #type action-pause gamehours 0.3 }
                    { #type action-change-patron-reservation action clear } ;; optional, they expire

                    { #type action-log-thought thought findvendingok valence 0.05 }
                     { #type action-debug-text text "Got vending" }
                    { #type action-react-to-grime grimethreshold 0.3 probability 0.1 multiplier -0.4 }
                ]
            }


            {
                name    script-go-end-visit
                actions [
                    { #type action-set-target type boardexit }
                    { #type action-navigate }

                     { #type action-debug-text text "All done with visit" }
                    { #type action-die }
                ]
            }
        ]
    }

    quests {
        maxactive { value 2 mods [ { #type golden-age-modifier id goldenage-apartments-free multiplier 1.5 } ] }
        questcancelmultiplier { value -1.5 }
        items [
            
            {
                id population-one
                locname "quest.population-one"
                locdesc "quest.population-one.desc"
                goals [
                    {
                        id population-one-goal-one
                        #type goal-have-peep-count count alllocals test atleast goal 50
                        locdesc "quest.population-one-goal-one.desc"
                    }
                ]
                startcash 500
                endcash 1500
            }
            {
                id population-two
                locname "quest.population-two"
                locdesc "quest.population-two.desc"
                visreqs [
                    { #type quest-complete-requirement id "population-one" }
                ]
                reqs [
                    { #type quest-complete-requirement id "population-one" }
                ]
                goals [
                    {
                        id population-two-goal-one
                        #type goal-have-peep-count count alllocals test atleast goal 100
                        locdesc "quest.population-two-goal-one.desc"
                    }
                ]
                startcash 1000  
                endcash 2000
            }
            {
                id population-three
                locname "quest.population-three"
                locdesc "quest.population-three.desc"
                visreqs [
                    { #type quest-complete-requirement id "population-two" }
                ]
                reqs [
                    { #type quest-complete-requirement id "population-two" }
                ]
                goals [
                    {
                        id population-three-goal-one
                        #type goal-have-peep-count count alllocals test atleast goal 250
                        locdesc "quest.population-three-goal-one.desc"
                    }
                ]
                startcash 1500  
                endcash 3000
                endgrants [
                    { #type grant-prestige value 1 }
                ]
            }

            {
                id money-zero
                locname "quest.money-zero"
                locdesc "quest.money-zero.desc"
                starter #true
                reqs [
                ]
                goals [
                    {
                        id money-one-goal-zero
                        #type goal-have-recurring-revenues test atleast goal 1000
                        locdesc "quest.money-zero-goal-one.desc"
                    }
                ]
                startcash 500
                endcash 500
                endgrants [
                    { #type grant-tokens type buzz value 10 }
                ]
            }
            {
                id money-one
                locname "quest.money-one"
                locdesc "quest.money-one.desc"
                visreqs [
                    { #type quest-complete-requirement id "money-zero" }
                ]
                goals [
                    {
                        id money-one-goal-one
                        #type goal-have-recurring-revenues test atleast goal 3000
                        locdesc "quest.money-one-goal-one.desc"
                    }
                ]
                startcash 500
                endcash 1500
                endgrants [
                    { #type grant-tokens type buzz value 25 }
                ]
            }
            {
                id money-two
                locname "quest.money-two"
                locdesc "quest.money-two.desc"
                visreqs [
                    { #type quest-complete-requirement id "money-one" }
                ]
                reqs [
                    { #type quest-complete-requirement id "money-one" }
                ]
                goals [
                    {
                        id money-two-goal-one
                        #type goal-have-recurring-revenues test atleast goal 5000
                        locdesc "quest.money-two-goal-one.desc"
                    }
                ]
                startcash 1000
                endcash 3000
                endgrants [
                    { #type grant-tokens type buzz value 50 }
                ]
            }
            {
                id money-three
                locname "quest.money-three"
                locdesc "quest.money-three.desc"
                visreqs [
                    { #type quest-complete-requirement id "money-two" }
                ]
                reqs [
                    { #type peep-count-requirement total #true count 50 }
                    { #type quest-complete-requirement id "money-two" }
                ]
                goals [
                    {
                        id money-three-goal-one
                        #type goal-have-recurring-revenues test atleast goal 10000
                        locdesc "quest.money-three-goal-one.desc"
                    }
                ]
                startcash 2000
                endcash 5000
                endgrants [
                    { #type grant-tokens type buzz value 100 }
                    { #type grant-prestige value 1 }
                ]
            }

            {
                id office-level-one
                locname "quest.office-level-one"
                locdesc "quest.office-level-one.desc"
                goals [
                    {
                        id quest.office-level-one-goal-one
                        #type goal-count-units tags [ insurance-one ] test atleast goal 4
                        locdesc "quest.office-level-one-goal-one.desc"
                    }
                    {
                        id quest.office-level-one-goal-two
                        #type goal-count-units tags [ accounting-one ] test atleast goal 4
                        locdesc "quest.office-level-one-goal-two.desc"
                    }
                    {
                        id quest.office-level-one-goal-three
                        #type goal-count-units tags [ legal-one ] test atleast goal 4
                        locdesc "quest.office-level-one-goal-three.desc"
                    }
                    {
                        id quest.office-level-one-goal-four
                        #type goal-count-units tags [ design-one ] test atleast goal 4
                        locdesc "quest.office-level-one-goal-four.desc"
                    }
                ]
                startcash 500
                endcash 1000
                endgrants [
                    { #type grant-tokens type favors value 5 }
                ]
            }
            {
                id office-level-two
                locname "quest.office-level-two"
                locdesc "quest.office-level-two.desc"
                visreqs [
                    { #type quest-complete-requirement id "office-level-one" }
                ]
                reqs [
                    { #type quest-complete-requirement id "office-level-one" }
                    { #type prestige-requirement value 2 }
                ]
                goals [
                    {
                        id quest.office-level-two-goal-one
                        #type goal-count-units tags [ legal-two ] test atleast goal 3
                        locdesc "quest.office-level-two-goal-one.desc"
                    }
                    {
                        id quest.office-level-two-goal-two
                        #type goal-count-units tags [ medical-two ] test atleast goal 3
                        locdesc "quest.office-level-two-goal-two.desc"
                    }
                    {
                        id quest.office-level-two-goal-three
                        #type goal-count-units tags [ financial-two ] test atleast goal 3
                        locdesc "quest.office-level-two-goal-three.desc"
                    }
                    {
                        id quest.office-level-two-goal-four
                        #type goal-count-units tags [ creative-two ] test atleast goal 3
                        locdesc "quest.office-level-two-goal-four.desc"
                    }
                ]
                startcash 1000
                endcash 3000
                endgrants [
                    { #type grant-tokens type favors value 20 }
                ]
            }
            {
                id office-level-three
                locname "quest.office-level-three"
                locdesc "quest.office-level-three.desc"
                visreqs [
                    { #type prestige-requirement value 9 }
                ]
                reqs [
                    { #type quest-complete-requirement id "office-level-two" }
                ]
                goals [
                    {
                        id quest.office-level-three-goal-one
                        #type goal-count-units tags [ office-three ] test atleast goal 6
                        locdesc "quest.office-level-three-goal-one.desc"
                    }
                ]
                startcash 2500
                endcash 5000
                endgrants [
                    { #type grant-tokens type favors value 40 }
                ]
            }
            {
                id office-level-four
                locname "quest.office-level-four"
                locdesc "quest.office-level-four.desc"
                visreqs [
                    { #type prestige-requirement value 14 }
                ]
                reqs [
                    { #type quest-complete-requirement id "office-level-three" }
                ]
                goals [
                    {
                        id quest.office-level-four-goal-one
                        #type goal-count-units tags [ office-four ] test atleast goal 3
                        locdesc "quest.office-level-four-goal-one.desc"
                    }
                ]
                startcash 5000
                endcash 10000
                endgrants [
                    { #type grant-tokens type favors value 75 }
                    { #type grant-prestige value 1 }
                ]
            }

            {
                id office-peeps-one
                locname "quest.office-peeps-one"
                locdesc "quest.office-peeps-one.desc"
                visreqs [
                    { #type peep-count-requirement total #true count 50 }
                ]
                goals [
                    {
                        id quest.office-peeps-one-goal-one
                         #type goal-have-peep-count count specificpeeps type officeworker test atleast goal 50
                         locdesc "quest.office-peeps-goal.desc"
                    }
                ]
                startcash 500
                endcash 1000
                endgrants [
                    { #type grant-tokens type buzz value 50 }
                ]
            }
            {
                id office-peeps-two
                locname "quest.office-peeps-two"
                locdesc "quest.office-peeps-two.desc"
                visreqs [
                    { #type peep-count-requirement total #true count 40 }
                ]
                reqs [
                    { #type quest-complete-requirement id "office-peeps-one" }
                ]
                goals [
                    {
                        id quest.office-peeps-two-goal-one
                         #type goal-have-peep-count count specificpeeps type officeworker test atleast goal 150
                         locdesc "quest.office-peeps-goal.desc"
                    }
                ]
                startcash 1500
                endcash 3000
                endgrants [
                    { #type grant-tokens type buzz value 100 }
                ]
            }
            {
                id office-peeps-three
                locname "quest.office-peeps-three"
                locdesc "quest.office-peeps-three.desc"
                visreqs [
                    { #type quest-complete-requirement id "office-peeps-two" }
                ]
                reqs [
                    { #type quest-complete-requirement id "office-peeps-two" }
                ]
                goals [
                    {
                        id quest.office-peeps-three-goal-one
                         #type goal-have-peep-count count specificpeeps type officeworker test atleast goal 300
                         locdesc "quest.office-peeps-goal.desc"
                    }
                ]
                startcash 5000
                endcash 10000
                endgrants [
                    { #type grant-tokens type buzz value 250  }
                    { #type grant-prestige value 1 }
                ]
            }

            {
                id residential-peeps-one
                locname "quest.residential-peeps-one"
                locdesc "quest.residential-peeps-one.desc"
                visreqs [
                    { #type peep-count-requirement total #true count 50 }
                ]
                goals [
                    {
                        id quest.residential-peeps-one-goal-one
                        #type goal-have-peep-count count specificpeeps type resident test atleast goal 50
                        locdesc "quest.residential-peeps-goal.desc"
                    }
                ]
                startcash 500
                endcash 1000
                endgrants [
                    { #type grant-tokens type favors value 10 }
                ]
            }
            {
                id residential-peeps-two
                locname "quest.residential-peeps-two"
                locdesc "quest.residential-peeps-two.desc"
                visreqs [
                    { #type quest-complete-requirement id "residential-peeps-one" }
                ]
                reqs [
                    { #type quest-complete-requirement id "residential-peeps-one" }
                ]
                goals [
                    {
                        id quest.residential-peeps-one-goal-two
                        #type goal-have-peep-count count specificpeeps type resident test atleast goal 100
                        locdesc "quest.residential-peeps-goal.desc"
                    }
                ]
                startcash 1500
                endcash 3000
                endgrants [
                    { #type grant-tokens type favors value 25 }
                ]
            }
            {
                id residential-peeps-three
                locname "quest.residential-peeps-three"
                locdesc "quest.residential-peeps-three.desc"
                visreqs [
                    { #type quest-complete-requirement id "residential-peeps-two" }
                ]
                reqs [
                    { #type quest-complete-requirement id "residential-peeps-two" }
                ]
                goals [
                    {
                        id quest.residential-peeps-one-goal-three
                        #type goal-have-peep-count count specificpeeps type resident test atleast goal 150
                        locdesc "quest.residential-peeps-goal.desc"
                    }
                ]
                startcash 2000
                endcash 4000
                endgrants [
                    { #type grant-tokens type favors value 50 }
                ]
            }
            {
                id residential-peeps-four
                locname "quest.residential-peeps-four"
                locdesc "quest.residential-peeps-four.desc"
                visreqs [
                    { #type quest-complete-requirement id "residential-peeps-three" }
                ]
                reqs [
                    { #type quest-complete-requirement id "residential-peeps-three" }
                ]
                goals [
                    {
                        id quest.residential-peeps-one-goal-four
                        #type goal-have-peep-count count specificpeeps type resident test atleast goal 250
                        locdesc "quest.residential-peeps-goal.desc"
                    }
                ]
                startcash 2000
                endcash 4000
                endgrants [
                    { #type grant-tokens type favors value 100 }
                    { #type grant-prestige value 1 }
                ]
            }

            {
                id apartments-one
                locname "quest.apartments-one"
                locdesc "quest.apartments-one.desc"
                goals [
                    {
                        id quest.apartments-one-goal-one
                        #type goal-count-units tags [ apt-studio-low apt-studio-high ] test atleast goal 10
                        locdesc "quest.apartments-one-goal-one.desc"
                    }
                ]
                startcash 500
                endcash 1000
            }
            {
                id apartments-two
                locname "quest.apartments-two"
                locdesc "quest.apartments-two.desc"
                visreqs [
                    { #type quest-complete-requirement id "apartments-one" }
                ]
                reqs [
                    { #type quest-complete-requirement id "apartments-one" }
                ]
                goals [
                    {
                        id quest.apartments-two-goal-one
                        #type goal-count-units tags [ apt-1br-low apt-1br-high ] test atleast goal 16
                        locdesc "quest.apartments-two-goal-one.desc"
                    }
                ]
                startcash 1500
                endcash 5000
            }
            {
                id apartments-three
                locname "quest.apartments-three"
                locdesc "quest.apartments-three.desc"
                visreqs [
                    { #type quest-complete-requirement id "apartments-two" }
                ]
                reqs [
                    { #type quest-complete-requirement id "apartments-two" }
                ]
                goals [
                    {
                        id quest.apartments-three-goal-one
                        #type goal-count-units tags [ apt-2br-low apt-2br-low-kids apt-2br-high apt-2br-high-kids apt-large-2br-low apt-large-2br-high ] test atleast goal 20
                        locdesc "quest.apartments-three-goal-one.desc"
                    }
                ]
                startcash 2000
                endcash 8000
                endgrants [
                    { #type grant-prestige value 1 }
                ]
            }
            {
                id apartments-four
                locname "quest.apartments-four"
                locdesc "quest.apartments-four.desc"
                visreqs [
                   { #type quest-complete-requirement id "apartments-three" }
                ]
                reqs [
                    { #type quest-complete-requirement id "apartments-three" }
                ]
                goals [
                    {
                        id quest.apartments-four-goal-one
                        #type goal-count-units tags [ apt-four-a apt-four-b ] test atleast goal 10
                        locdesc "quest.apartments-four-goal-one.desc"
                    }
                ]
                startcash 2000
                endcash 8000
                endgrants [
                    { #type grant-prestige value 2 }
                ]
            }

            {
                id residential-luxury-one
                locname "quest.residential-luxury-one"
                locdesc "quest.residential-luxury-one.desc"
                visreqs [
                    { #type peep-count-requirement total #true count 100 }
                ]
                reqs [
                    { #type quest-complete-requirement id "residential-peeps-one" }
                ]
                goals [
                    {
                        id quest.residential-luxury-one-goal-one
                        #type goal-count-units tags [ apt-studio-lux apt-1br-high apt-2br-high apt-2br-high-kids lux-three ] test atleast goal 10
                        locdesc "quest.residential-luxury-one-goal-one.desc"
                    }
                ]
                startcash 1000
                endcash 2500
                endgrants [
                    { #type grant-tokens type buzz value 100 }
                ]
            }
            {
                id residential-luxury-two
                locname "quest.residential-luxury-two"
                locdesc "quest.residential-luxury-two.desc"
                visreqs [
                    { #type quest-complete-requirement id "residential-luxury-one" }
                ]
                reqs [
                    { #type quest-complete-requirement id "residential-luxury-one" }
                ]
                goals [
                    {
                        id quest.residential-luxury-two-goal-one
                        #type goal-count-units tags [ apt-2br-high apt-2br-high-kids lux-three apt-four-b ] test atleast goal 8
                        locdesc "quest.residential-luxury-two-goal-one.desc"
                    }
                ]
                startcash 2000
                endcash 5000
                endgrants [
                    { #type grant-tokens type buzz value 250 }
                ]
            }
            {
                id residential-luxury-three
                locname "quest.residential-luxury-three"
                locdesc "quest.residential-luxury-three.desc"
                visreqs [
                    { #type quest-complete-requirement id "residential-luxury-two" }
                ]
                reqs [
                    { #type quest-complete-requirement id "residential-luxury-two" }
                ]
                goals [
                    {
                        id quest.residential-luxury-three-goal-one
                        #type goal-count-units tags [ lux-three apt-four-b ] test atleast goal 4
                        locdesc "quest.residential-luxury-three-goal-one.desc"
                    }
                ]
                startcash 4000
                endcash 10000
                endgrants [
                    { #type grant-tokens type buzz value 500 }
                    { #type grant-prestige value 1 }
                ]
            }

            {
                id restaurant-small
                locname "quest.restaurant-small"
                locdesc "quest.restaurant-small.desc"
                visreqs [
                ;    { #type peep-count-requirement total #true count 25 }
                ]
                goals [
                    {
                        id quest.restaurant-small-goal-one
                        #type goal-count-units tags [ breakfast-one breakfast-two ] test atleast goal 1
                        locdesc "quest.restaurant-small-goal-one.desc"
                    }
                    {
                        id quest.restaurant-small-goal-two
                        #type goal-count-units tags [ lunch-one lunch-two ] test atleast goal 1
                        locdesc "quest.restaurant-small-goal-two.desc"
                    }
                    {
                        id quest.restaurant-small-goal-three
                        #type goal-count-units tags [ cafe ] test atleast goal 1
                        locdesc "quest.restaurant-small-goal-three.desc"
                    }
                ]
                startcash 500
                endcash 1500
            }
            {
                id restaurant-medium
                locname "quest.restaurant-medium"
                locdesc "quest.restaurant-medium.desc"
                visreqs [
                    { #type quest-complete-requirement id "restaurant-small" }
                    { #type peep-count-requirement total #true count 50 }
                ]
                reqs [
                    { #type quest-complete-requirement id "restaurant-small" }
                ]
                goals [
                    {
                        id quest.restaurant-medium-goal-one
                        #type goal-count-units tags [ breakfast-two ] test atleast goal 2
                        locdesc "quest.restaurant-medium-goal-one.desc"
                    }
                    {
                        id quest.restaurant-medium-goal-two
                        #type goal-count-units tags [ lunch-two ] test atleast goal 2
                        locdesc "quest.restaurant-medium-goal-two.desc"
                    }
                    {
                        id quest.restaurant-medium-goal-three
                        #type goal-count-units tags [ dinner-two ] goal 2
                        locdesc "quest.restaurant-medium-goal-three.desc"
                    }
                ]
                startcash 1000
                endcash 3000
            }
            {
                id restaurant-large
                locname "quest.restaurant-large"
                locdesc "quest.restaurant-large.desc"
                visreqs [
                    { #type quest-complete-requirement id "restaurant-medium" }
                    { #type peep-count-requirement total #true count 100 }
                ]
                reqs [
                    { #type quest-complete-requirement id "restaurant-medium" }
                ]
                goals [
                    {
                        id quest.restaurant-large-goal-one
                        #type goal-count-units tags [ lunch-three ] test atleast goal 2
                        locdesc "quest.restaurant-large-goal-one.desc"
                    }
                    {
                        id quest.restaurant-large-goal-two
                        #type goal-count-units tags [ dinner-three ] test atleast goal 2
                        locdesc "quest.restaurant-large-goal-two.desc"
                    }
                    {
                        id quest.restaurant-large-goal-three
                        #type goal-count-units tags [ bar-three ] test atleast goal 2
                        locdesc "quest.restaurant-large-goal-three.desc"
                    }
                ]
                startcash 2000
                endcash 7000
                endgrants [
                    { #type grant-prestige value 1 }
                ]
            }
            {
                id restaurant-gourmet
                locname "quest.restaurant-gourmet"
                locdesc "quest.restaurant-gourmet.desc"
                visreqs [
                    { #type quest-complete-requirement id "restaurant-large" }
                ]
                goals [
                    {
                        id quest.restaurant-gourmet-goal-one
                        #type goal-count-units tags [ dinner-four ] test atleast goal 4
                        locdesc "quest.restaurant-gourmet-goal-one.desc"
                    }
                ]
                startcash 2000
                endcash 7000
                endgrants [
                    { #type grant-prestige value 2 }
                ]
            }

            {
                id retail-small
                locname "quest.retail-small"
                locdesc "quest.retail-small.desc"
                visreqs [
                    { #type peep-count-requirement total #true count 30 }
                ]
                reqs [
                    { #type peep-count-requirement total #true count 50 }
                ]
                goals [
                    {
                        id quest.retail-small-goal-one
                        #type goal-count-units tags [ retail-one ] test atleast goal 4
                        locdesc "quest.retail-small-goal-one.desc"
                    }
                ]
                startcash 500
                endcash 1000
            }
            {
                id retail-medium
                locname "quest.retail-medium"
                locdesc "quest.retail-medium.desc"
                visreqs [
                    { #type quest-complete-requirement id "retail-small" }
                    { #type peep-count-requirement total #true count 75 }
                ]
                reqs [
                    { #type quest-complete-requirement id "retail-small" }
                ]
                goals [
                    {
                        id quest.retail-medium-goal-one
                        #type goal-count-units tags [ clothing-two ] test atleast goal 1
                        locdesc "quest.retail-medium-goal-one.desc"
                    }
                    {
                        id quest.retail-medium-goal-two
                        #type goal-count-units tags [ electronics-two ] test atleast goal 1
                        locdesc "quest.retail-medium-goal-two.desc"
                    }
                    {
                        id quest.retail-medium-goal-three
                        #type goal-count-units tags [ fashion-two ] test atleast goal 1
                        locdesc "quest.retail-medium-goal-three.desc"
                    }
                ]
                startcash 1000
                endcash 3000
            }
            {
                id retail-large
                locname "quest.retail-large"
                locdesc "quest.retail-large.desc"
                visreqs [
                    { #type quest-complete-requirement id "retail-medium" }
                    { #type peep-count-requirement total #true count 100 }
                ]
                reqs [
                    { #type quest-complete-requirement id "retail-medium" }
                ]
                goals [
                    {
                        id quest.retail-large-goal-one
                        #type goal-count-units tags [ food-three ] test atleast goal 1
                        locdesc "quest.retail-large-goal-one.desc"
                    }
                    {
                        id quest.retail-large-goal-two
                        #type goal-count-units tags [ electronics-three ] test atleast goal 1
                        locdesc "quest.retail-large-goal-two.desc"
                    }
                    {
                        id quest.retail-large-goal-three
                        #type goal-count-units tags [ departmentstore ] test atleast goal 1
                        locdesc "quest.retail-large-goal-three.desc"
                    }
                ]
                startcash 1500
                endcash 5000
                endgrants [
                    { #type grant-prestige value 1 }
                ]
            }
            {
                id retail-lux
                locname "quest.retail-lux"
                locdesc "quest.retail-lux.desc"
                visreqs [
                    { #type quest-complete-requirement id "retail-large" }
                ]
                goals [
                    {
                        id quest.retail-lux-goal-one
                        #type goal-count-units tags [ retail-four ] test atleast goal 4
                        locdesc "quest.retail-lux-goal-one.desc"
                    }
                ]
                startcash 1500
                endcash 7500
                endgrants [
                    { #type grant-prestige value 2 }
                ]
            }
            {
                id rooftops-one
                locname "quest.rooftop-one"
                locdesc "quest.rooftop-one.desc"
                visreqs [
                    { #type prestige-requirement value 7 }
                ]
                goals [

                    {
                        id quest.rooftop-one-goal-one
                        #type goal-count-units tags [ penthouse-medium ] test atleast goal 4
                        locdesc "quest.rooftop-one-goal-one.desc"
                    }
                ]
                startcash 750
                endcash 5000
                endgrants [
                    { #type grant-prestige value 1 }
                ]
            }
            {
                id rooftops-two
                locname "quest.rooftop-two"
                locdesc "quest.rooftop-two.desc"
                visreqs [
                    { #type prestige-requirement value 15 }
                ]
                goals [
                    {
                        id quest.rooftop-two-goal-two
                        #type goal-count-units tags [ penthouse-luxury ] test atleast goal 4
                        locdesc quest.rooftop-two-goal-one.desc
                    }
                ]
                startcash 1500
                endcash 10000
                endgrants [
                    { #type grant-prestige value 3 }
                    { #type grant-tokens type buzz value 150 }
                ]
            }

            ;;;;;; quests for scenarios
            
            
        ]
    }


    ;; ;;;;;;;;;;;;;;;; ui build ribbon

    ui {
        mainribbon [
        {
            group [
            {
                type        button
                locname     "ui.build.floor"
                mouseover   "ui.build.floor.mo"

                action      subribbon
                values      [ "subribbon-floor" ]
            }
            {
                type        button
                locname     "ui.build.bulldoze"
                mouseover   "ui.build.bulldoze.mo"
                sfx         buttonclickbulldozer

                action      callback
                values      [ bulldoze ]
            }
            {
                type        button
                locname     "ui.build.utilities"
                mouseover   "ui.build.utilities.mo"

                action      subribbon
                values      [ "subribbon-utilities" ]
            }
            {
                type        button
                locname     "ui.build.specialmods"
                mouseover   "ui.build.specialmods.mo"
                visreqs     [ { #type placable-mods-installed-requirement } ]

                action      callback
                values      [ mods ]
            }
            ]
        }
        {
            group [
            {
                type        button
                locname     "ui.build.offices"
                mouseover   "ui.build.offices.mo"
                reqs        [
                           { #type scenario-requirement tags [ "scenario-5" ] result fail }
                           { #type scenario-requirement tags [ "scenario-6" ] result fail } 
                           { #type scenario-requirement tags [ "scenario-15" ] result fail }
                           { #type scenario-meta-requirement tags [ "scenario-13" ] reqs [ { #type quest-complete-requirement id "s13-quest-two" } ] otherwise pass } 
                ]

                action      subribbon
                values      [ "subribbon-offices" ]
            }
            {
                type        button
                locname     "ui.build.restaurants"
                mouseover   "ui.build.restaurants.mo"

                action      subribbon
                values      [ "subribbon-restaurants" ]
            }
            {
                type        button
                locname     "ui.build.residential"
                mouseover   "ui.build.residential.mo"
                reqs [
                    { #type tutorial-done-requirement except [ "tutorial3" ] }
                    { #type scenario-requirement tags [ "scenario-1" "scenario-3" "scenario-8" "scenario-12" "scenario-11" ] result fail }
                ]

                action      subribbon
                values      [ "subribbon-residential" ]
            }
            {
                type        button
                locname     "ui.build.retail"
                mouseover   "ui.build.retail.mo"
                reqs [
                    { #type prestige-requirement value 2 }
                    { #type tutorial-done-requirement except [ "tutorial3" ] }
                ]

                action      subribbon
                values      [ "subribbon-retail" ]
            }
            ]
        }
        {
            group [
            {
                type        button
                locname     "ui.build.services"
                mouseover   "ui.build.services.mo"

                action      subribbon
                values      [ "subribbon-services" ]
            }
            {
                type        button
                locname     "ui.build.decos"
                mouseover   "ui.build.decos.mo"
                reqs        [ 
                    { #type tutorial-done-requirement except [ "tutorial3" ] } 
                    { #type prestige-requirement value 1 }
                ]

                action      subribbon
                values      [ "subribbon-decos" ]
            }
            {
                type        button
                locname     "ui.build.consultants"
                mouseover   "ui.build.consultants.mo"
                reqs [
                    { #type tutorial-done-requirement except [ "tutorial3" ] }
                ]

                action      subribbon
                values      [ "subribbon-consultants" ]
            }
            {
                type        button
                locname     "ui.build.arts"
                mouseover   "ui.build.arts.mo"
                reqs        [ { #type tutorial-done-requirement except [ "tutorial3" ] } ]

                action      subribbon
                values      [ "subribbon-art" ]
            }
            ]
        }
        {
            group [
            {
                type        button
                locname     "ui.build.contracts"
                mouseover   "ui.build.contracts.mo"

                action      callback
                values      [ contracts ]
            }
;            {
;                type        separator
;            }
            {
                type        button
                locname     "ui.build.ada"
                mouseover   "ui.build.ada.mo"

                action      callback
                values      [ ada ]
            }
            ]
        }
        ]

        subribbons [
        {
            id      "subribbon-floor"
            tabs    [ {
                id          "subribbon-floor-infrastructure"
                tabname     "ui.build.floor.tab.infrastructure"
                tabheader   "ui.build.floor.text"
                elements    [
                {
                    type        button
                    locname     "ui.build.floor.floor"
                    mouseover   "ui.build.floor.floor.mo"

                    action      callback
                    values      [ addfloor ]
                }
                {
                    type        separator
                }
                {
                    type        button
                    locname     "ui.build.floor.stairs"

                    action      placetemplate
                    values      [ "path-stairs" ]
                }
                {
                    type        button
                    locname     "ui.build.floor.elevator"
                    reqs        [
                            { #type scenario-meta-requirement tags [ "scenario-4" ]
                            reqs [ { #type consultant-upgrade-requirement id "cons-b-2" } ] 
                            otherwise pass }
                                ]

                    action      callback
                    values      [ buildelevator "path-elevator" ]
                }
                {
                    type        button
                    locname     "ui.build.floor.elevator.fancy"
                    reqs [
                        { #type consultant-upgrade-requirement id "cons-c-5" }
                    ]

                    action      callback
                    values      [ buildelevator "path-elevator-fancy" ]
                }
                ;{
                ;    type        button
                ;    locname     "ui.build.floor.escalator"
                ;    reqs [
                ;        { #type prestige-requirement value 3 }
                ;    ]

                ;    action      placetemplate
                ;    values      [ "path-escalator" ]
                ;}

                {
                    type        separator
                }
                {
                    type        button
                    locname     "ui.build.floor.extended"
                    mouseover   "ui.build.floor.extended.mo"
                    reqs        [
                        { #type floor-tiles-requirement atleast 100 }
                        { #type tutorial-done-requirement }
                    ]

                    action      callback
                    values      [ addfloorextended ]
                }
                {
                    type        button
                    locname     "ui.build.floor.skybridge"
                    mouseover   "ui.build.floor.skybridge.mo"
                    reqs        [
                        { #type floor-count-requirement atleast 10 }
                        { #type tutorial-done-requirement }
                    ]

                    action      callback
                    values      [ addskybridge ]
                }
                
                ] ;; elements
            }
            {
                id              "subribbon-floor-staff"
                tabname         "ui.build.floor.tab.staff"
                tabheader       "ui.build.floor.staff.header"
                elements [
                {
                    type        button
                    locname     "ui.build.floor.maintenance"

                    action      placetemplate
                    values      [ "support-maintenance" ]
                }
                {
                    type        button
                    locname     "ui.build.floor.maintenance.expanded"
                    reqs [
                    ;    { #type consultant-upgrade-requirement id "cons-c-4" }
                    ]

                    action      placetemplate
                    values      [ "support-maintenance-expanded" ]
                }
                {
                    type        button
                    locname     "ui.build.floor.construction.expanded"
                    reqs [
                     ;   { #type consultant-upgrade-requirement id "cons-c-1" }
                    ]

                    action      placetemplate
                    values      [ "support-construction-expanded" ]
                }
                {
                    type        button
                    locname     "ui.build.floor.construction"
                    reqs [
                     ;   { #type consultant-upgrade-requirement id "cons-c-1" }
                    ]
                    visreqs [
                        { #type entity-count-requirement type exactly count 0 template support-construction onlyenabled #true }
                    ]

                    action      placetemplate
                    values      [ "support-construction" ]
                }
                ]
            }
            {
                id          "subribbon-special-trash"
                tabname     "ui.build.special.tab.trash"
                tabheader   "ui.build.special.trash.header"
                elements    [
                {
                    type        text
                    locname     "ui.build.special.trash.bins"
                }
                {
                    type        button
                    action      placetemplate
                    values      [ "support-trashbin" ]
                    locname     "ui.build.special.trash.bin"
                    mouseover   "ui.build.special.trash.bin.mo"
                }
                {
                    type        button
                    action      placetemplate
                    values      [ "support-recyclebin" ]
                    locname     "ui.build.special.recyc.bin"
                    mouseover   "ui.build.special.recyc.bin.mo"
                }
                {
                    type        text
                    locname     "ui.build.special.trash.rooms"
                }
                {
                    type        button
                    action      placetemplate
                    values      [ "support-trashroom" ]
                    mouseover   "ui.build.special.trash.room.mo"
                    locname     "ui.build.special.trash.room"
                }
                {
                    type        button
                    action      placetemplate
                    values      [ "support-recycle" ]
                    mouseover   "ui.build.special.recyc.room.mo"
                    locname     "ui.build.special.recyc.room"
                }
                ] ;; elements
            }
            {
                id          "subribbon-special-docks"
                tabname     "ui.build.special.tab.docks"
                tabheader   "ui.build.special.docks.header"
                elements    [
                {
                    type        button
                    action      placetemplate
                    reqs        [ { #type prestige-requirement value 2 } ]
                    values      [ "support-loadingdock" ]
                    locname     "ui.build.special.dock"
                }
                {
                    type        separator
                }
                {
                        type        button
                        locname     "ui.build.special.custodian"
                        mouseover   "ui.build.special.custodian.mo"

                        action      placetemplate
                        values      [ "amenity-custodian" ]
                }
                {

                        type        button
                        locname     "ui.build.special.broomcloset"
                        mouseover   "ui.build.special.broomcloset.mo"

                        action      placetemplate
                        values      [ "amenity-broomcloset" ]
                }

                ] ;; elements
            }
            {
                id          "subribbon-special-transit"
                tabname     "ui.build.special.tab.transit"
                tabheader   "ui.build.special.transit.header"
                elements    [
                    {
                        type        button
                        locname     "ui.build.transit.metro"
                        mouseover   "ui.build.transit.metro.mo"

                        action      placetemplate
                        values      [ "spawner-metro" ]
                    }
                ] ;; elements
            }

             ] ;; tabs
        }

        {
            id      "subribbon-utilities"
            tabs    [

            ;; power tab
            {
                id              "subribbon-utilities-power"
                tabname         "ui.build.util.tab.power"
                tabheader       "ui.build.util.power.header"
                tabcallback     "utilpower"
                elements [
                {
                    type        text
                    locname     "ui.build.util.power.t1"
                }
                {
                    type        button
                    locname     "ui.build.util.power.add"
                    mouseover   "ui.build.util.power.add.mo"
                    action      callback
                    values      [ addutil utilpower ]
                }
                {
                    type        button
                    locname     "ui.build.util.power.remove"
                    mouseover   "ui.build.util.power.remove.mo"
                    action      callback
                    values      [ delutil utilpower ]
                }
                {
                    type        separator
                }
                {
                    type        text
                    locname     "ui.build.util.closet.wiring"
                }
                {
                    type        button
                    locname     "ui.build.util.power.closet"
                    action      callback
                    values      [ buyutil utilpower "closet-electrical" ]
                }
                {
                    type        separator
                }
                {
                    type        text
                    locname     "ui.build.util.power.t2"
                }
                {
                    type        button
                    locname     "ui.build.util.power.meter1"
                    action      callback
                    values      [ buyutil utilpower "closet-powermeter-l1" ]
                }
                {
                    type        button
                    locname     "ui.build.util.power.meter2"
                    action      callback
                    values      [ buyutil utilpower "closet-powermeter-l2" ]
                }
                {
                    type        button
                    locname     "ui.build.util.power.meter3"
                    action      callback
                    values      [ buyutil utilpower "closet-powermeter-l3" ]
                }
                ] ;; elements
            }

            ;; phone tab
            {
                id              "subribbon-utilities-phone"
                tabname         "ui.build.util.tab.phone"
                tabheader       "ui.build.util.phone.header"
                tabcallback     "utilphone"
                elements [
                {
                    type        text
                    locname     "ui.build.util.phone.t1"
                }
                {
                    type        button
                    locname     "ui.build.util.phone.add"
                    mouseover   "ui.build.util.phone.add.mo"
                    action      callback
                    values      [ addutil utilphone ]
                }
                {
                    type        button
                    locname     "ui.build.util.phone.remove"
                    mouseover   "ui.build.util.phone.remove.mo"
                    action      callback
                    values      [ delutil utilphone ]
                }
                {
                    type        separator
                }
                {
                    type        text
                    locname     "ui.build.util.closet.wiring"
                }
                {
                    type        button
                    locname     "ui.build.util.phone.closet"
                    action      callback
                    values      [ buyutil utilphone "closet-electrical" ]
                }
                {
                    type        separator
                }
                {
                    type        text
                    locname     "ui.build.util.phone.t2"
                }
                {
                    type        button
                    locname     "ui.build.util.phone.meter1"
                    action      callback
                    values      [ buyutil utilphone "closet-phonemeter-l1" ]
                }
                {
                    type        button
                    locname     "ui.build.util.phone.meter2"
                    action      callback
                    values      [ buyutil utilphone "closet-phonemeter-l2" ]
                }
                {
                    type        button
                    locname     "ui.build.util.phone.meter3"
                    action      callback
                    values      [ buyutil utilphone "closet-phonemeter-l3" ]
                }
                ] ;; elements
            }

            ;; cable tab
            {
                id              "subribbon-utilities-cable"
                tabname         "ui.build.util.tab.cable"
                tabheader       "ui.build.util.cable.header"
                tabcallback     "utilcable"
                elements [
                {
                    type        text
                    locname     "ui.build.util.cable.t1"
                }
                {
                    type        button
                    locname     "ui.build.util.cable.add"
                    mouseover   "ui.build.util.cable.add.mo"
                    action      callback
                    values      [ addutil utilcable ]
                }
                {
                    type        button
                    locname     "ui.build.util.cable.remove"
                    mouseover   "ui.build.util.cable.remove.mo"
                    action      callback
                    values      [ delutil utilcable ]
                }
                {
                    type        separator
                }
                {
                    type        text
                    locname     "ui.build.util.closet.wiring"
                }
                {
                    type        button
                    locname     "ui.build.util.cable.closet"
                    action      callback
                    values      [ buyutil utilcable "closet-electrical" ]
                }
                {
                    type        separator
                }
                {
                    type        text
                    locname     "ui.build.util.cable.t2"
                }
                {
                    type        button
                    locname     "ui.build.util.cable.meter1"
                    action      callback
                    values      [ buyutil utilcable "closet-cablemeter-l1" ]
                }
                {
                    type        button
                    locname     "ui.build.util.cable.meter2"
                    action      callback
                    values      [ buyutil utilcable "closet-cablemeter-l2" ]
                }
                {
                    type        button
                    locname     "ui.build.util.cable.meter3"
                    action      callback
                    values      [ buyutil utilcable "closet-cablemeter-l3" ]
                }
                ] ;; elements
            }

            ;; water tab
            {
                id              "subribbon-utilities-water"
                tabname         "ui.build.util.tab.water"
                tabheader       "ui.build.util.water.header"
                tabcallback     "utilwater"
                elements [
                {
                    type        text
                    locname     "ui.build.util.water.t1"
                }
                {
                    type        button
                    locname     "ui.build.util.water.add"
                    mouseover   "ui.build.util.water.add.mo"
                    action      callback
                    values      [ addutil utilwater ]
                }
                {
                    type        button
                    locname     "ui.build.util.water.remove"
                    mouseover   "ui.build.util.water.remove.mo"
                    action      callback
                    values      [ delutil utilwater ]
                }
                {
                    type        separator
                }
                {
                    type        text
                    locname     "ui.build.util.closet.plumbing"
                }
                {
                    type        button
                    locname     "ui.build.util.water.closet"
                    action      callback
                    values      [ buyutil utilwater "closet-plumbing" ]
                }
                {
                    type        separator
                }
                {
                    type        text
                    locname     "ui.build.util.water.t2"
                }
                {
                    type        button
                    locname     "ui.build.util.water.meter1"
                    action      callback
                    values      [ buyutil utilwater "closet-watermeter-l1" ]
                }
                {
                    type        button
                    locname     "ui.build.util.water.meter2"
                    action      callback
                    values      [ buyutil utilwater "closet-watermeter-l2" ]
                }
                {
                    type        button
                    locname     "ui.build.util.water.meter3"
                    action      callback
                    values      [ buyutil utilwater "closet-watermeter-l3" ]
                }
                ] ;; elements
            }

            ;; gas tab
            {
                id              "subribbon-utilities-gas"
                tabname         "ui.build.util.tab.gas"
                tabheader       "ui.build.util.gas.header"
                tabcallback     "utilgas"
                elements [
                {
                    type        text
                    locname     "ui.build.util.gas.t1"
                }
                {
                    type        button
                    locname     "ui.build.util.gas.add"
                    mouseover   "ui.build.util.gas.add.mo"
                    action      callback
                    values      [ addutil utilgas ]
                }
                {
                    type        button
                    locname     "ui.build.util.gas.remove"
                    mouseover   "ui.build.util.gas.remove.mo"
                    action      callback
                    values      [ delutil utilgas ]
                }
                {
                    type        separator
                }
                {
                    type        text
                    locname     "ui.build.util.closet.plumbing"
                }
                {
                    type        button
                    locname     "ui.build.util.gas.closet"
                    action      callback
                    values      [ buyutil utilgas "closet-plumbing" ]
                }
                {
                    type        separator
                }
                {
                    type        text
                    locname     "ui.build.util.gas.t2"
                }
                {
                    type        button
                    locname     "ui.build.util.gas.meter1"
                    action      callback
                    values      [ buyutil utilgas "closet-gasmeter-l1" ]
                }
                {
                    type        button
                    locname     "ui.build.util.gas.meter2"
                    action      callback
                    values      [ buyutil utilgas "closet-gasmeter-l2" ]
                }
                {
                    type        button
                    locname     "ui.build.util.gas.meter3"
                    action      callback
                    values      [ buyutil utilgas "closet-gasmeter-l3" ]
                }
                ] ;; elements
            }
            ] ;; tabs
        }

        {
            id      "subribbon-offices"
            tabs    [ {
                tabheader       "ui.build.office.text"
                elements    [
                {
                    type        button
                    locname     "ui.build.office.4w"
                    mouseover   "ui.build.office.4w.mo"
                    reqs [
                        { #type scenario-requirement tags [ "scenario-11" ] result fail }
                    ]

                    action      placetemplate
                    values      [ "emptyspace-office-4w" ]
                }
                {
                    type        button
                    locname     "ui.build.office.10w"
                    mouseover   "ui.build.office.10w.mo"
                    reqs [
                        { #type prestige-requirement value 2 }
                    ]

                    action      placetemplate
                    values      [ "emptyspace-office-10w" ]
                }
                {
                    type        button
                    locname     "ui.build.office.15w"
                    mouseover   "ui.build.office.15w.mo"
                    reqs [
                        { #type prestige-requirement value 9 }
                    ]

                    action      placetemplate
                    values      [ "emptyspace-office-15w" ]
                }
                {
                    type        button
                    locname     "ui.build.office.10w2t"
                    mouseover   "ui.build.office.10w2t.mo"
                    reqs [
                        { #type prestige-requirement value 14 }
                    ]

                    action      placetemplate
                    values      [ "emptyspace-office-10w2t" ]
                }
                ] ;; elements
            } ] ;; tabs
        }
        {
            id      "subribbon-residential"
            tabs    [ {
                tabheader       "ui.build.residential.text"
                elements [
                {
                    type        button
                    locname     "ui.build.residential.6w"
                    mouseover   "ui.build.residential.6w.mo"
                    reqs [
                    ]

                    action      placetemplate
                    values      [ "emptyspace-residential-6w" ]
                }
                {
                    type        button
                    locname     "ui.build.residential.8w"
                    mouseover   "ui.build.residential.8w.mo"
                    reqs [
                        { #type prestige-requirement value 2 }
                        { #type scenario-meta-requirement tags [ "scenario-15" ] reqs [ { #type quest-complete-requirement id "s15-quest-smalloffices" } ] otherwise pass }
                    ]
                    action      placetemplate
                    values      [ "emptyspace-residential-8w" ]
                }
                {
                    type        button
                    locname     "ui.build.residential.10w"
                    mouseover   "ui.build.residential.10w.mo"
                    reqs [
                        { #type prestige-requirement value 4 }
                        { #type scenario-meta-requirement tags [ "scenario-15" ] reqs [ { #type quest-complete-requirement id "s15-quest-smalloffices" } ] otherwise pass }
                    ]

                    action      placetemplate
                    values      [ "emptyspace-residential-10w" ]
                }
               {
                    type        button
                    locname     "ui.build.residential.16w"
                    mouseover   "ui.build.residential.16w.mo"
                    reqs [
                        { #type prestige-requirement value 5 }
                        { #type scenario-meta-requirement tags [ "scenario-15" ] reqs [ { #type quest-complete-requirement id "s15-quest-smalloffices" } ] otherwise pass }
                    ]

                    action      placetemplate
                    values      [ "emptyspace-residential-16w" ]
                }
                {
                    type        button
                    locname     "ui.build.residential.10w2t"
                    mouseover   "ui.build.residential.10w2t.mo"
                    reqs [
                        { #type prestige-requirement value 10 }
                        { #type scenario-meta-requirement tags [ "scenario-15" ] reqs [ { #type quest-complete-requirement id "s15-quest-mediumoffices" } ] otherwise pass }
                    ]

                    action      placetemplate
                    values      [ "emptyspace-residential-10w-2t" ]
               }
               {
                    type        button
                    locname     "ui.build.residential.15w2t"
                    mouseover   "ui.build.residential.15w2t.mo"
                    reqs [
                        { #type prestige-requirement value 15 }
                        { #type scenario-meta-requirement tags [ "scenario-15" ] reqs [ { #type quest-complete-requirement id "s15-quest-mediumoffices" } ] otherwise pass }
                    ]

                    action      placetemplate
                    values      [ "emptyspace-residential-15w-2t" ]
               }

                ;; rooftop
                {
                    type        button
                    locname     "ui.build.residential.rooftop.14w"
                    mouseover   "ui.build.residential.rooftop.14w.mo"
                    reqs [
                        { #type prestige-requirement value 7 }
                        { #type consultant-upgrade-requirement id cons-b-2 }
                        { #type floor-count-requirement atleast 10 }
                        { #type golden-ages id goldenage-apartments-satisfaction }
                    ]

                    action      placetemplate
                    values      [ "emptyspace-residential-rooftop-14w" ]
                }
                {
                    type        button
                    locname     "ui.build.residential.rooftop.18w"
                    mouseover   "ui.build.residential.rooftop.18w.mo"
                    reqs [
                        { #type prestige-requirement value 15 }
                        { #type floor-count-requirement atleast 25 }
                        { #type entity-count-requirement type atleast count 1 template consultant-aesthetics-gallery }
                        { #type golden-ages id goldenage-apartments-waitlist }
                    ]

                    action      placetemplate
                    values      [ "emptyspace-residential-rooftop-20w" ]
                }


                ] ;; elements
            } ] ;; tabs
        }
        {
            id      "subribbon-restaurants"
            tabs    [ {
                tabheader   "ui.build.restaurant.text"
                elements    [
                {
                    type        button
                    locname     "ui.build.restaurant.4w"
                    mouseover   "ui.build.restaurant.4w.mo"

                    action      placetemplate
                    values      [ "emptyspace-restaurant-4w" ]
                }
                {
                    type        button
                    locname     "ui.build.restaurant.8w"
                    mouseover   "ui.build.restaurant.8w.mo"
                    reqs [
                        { #type prestige-requirement value 3 }
                    ]

                    action      placetemplate
                    values      [ "emptyspace-restaurant-8w" ]
                }
                {
                    type        button
                    locname     "ui.build.restaurant.16w"
                    mouseover   "ui.build.restaurant.16w.mo"
                    reqs [
                        { #type prestige-requirement value 7 }
                    ]

                    action      placetemplate
                    values      [ "emptyspace-restaurant-16w" ]
                }
                {
                    type        button
                    locname     "ui.build.restaurant.14w"
                    mouseover   "ui.build.restaurant.14w.mo"
                    reqs [
                       { #type prestige-requirement value 13 }
                    ]

                    action      placetemplate
                    values      [ "emptyspace-restaurant-14w" ]
                }
                ;; rooftop
                {
                    type        button
                    locname     "ui.build.restaurant.rooftop.12w"
                    mouseover   "ui.build.restaurant.rooftop.12w.mo"
                    reqs [
                        { #type prestige-requirement value 8 }
                        { #type floor-count-requirement atleast 15 }
                        { #type golden-ages id goldenage-commercial-visitors }
                    ]

                    action      placetemplate
                    values      [ "emptyspace-restaurant-rooftop-12w" ]
                }
                {
                    type        button
                    locname     "ui.build.restaurant.rooftop.18w"
                    mouseover   "ui.build.restaurant.rooftop.18w.mo"
                    reqs [
                        { #type prestige-requirement value 15 sathit -0.4 }
                        { #type floor-count-requirement atleast 25 sathit -0.1 }
                        { #type golden-ages id goldenage-commercial-feature }
                    ]

                    action      placetemplate
                    values      [ "emptyspace-restaurant-rooftop-18w" ]
                }
                ] ;; elements
            } ] ;; tabs
        }
        {
            id      "subribbon-retail"
            tabs    [ {
                tabheader       "ui.build.retail.text"
                elements [
                {
                    type        button
                    locname     "ui.build.retail.7w"
                    mouseover   "ui.build.retail.7w.mo"

                    action      placetemplate
                    values      [ "emptyspace-retail-7w" ]
                }
                {
                    type        button
                    locname     "ui.build.retail.12w"
                    mouseover   "ui.build.retail.12w.mo"
                    reqs [
                        { #type prestige-requirement value 5 }
                        { #type scenario-meta-requirement tags [ "scenario-1" ] 
                            reqs [ { #type quest-complete-requirement id "s1-quest-retail-one" } ]
                            otherwise pass }
                    ]

                    action      placetemplate
                    values      [ "emptyspace-retail-12w" ]
                }
                {
                    type        button
                    locname     "ui.build.retail.12w2t"
                    mouseover   "ui.build.retail.12w2t.mo"
                    reqs [
                        { #type prestige-requirement value 10 }
                        { #type scenario-meta-requirement tags [ "scenario-1" ] 
                            reqs [ { #type quest-complete-requirement id "s1-quest-retail-two" } ]
                            otherwise pass }
                    ]

                    action      placetemplate
                    values      [ "emptyspace-retail-12w-2t" ]
                }
                {
                    type        button
                    locname     "ui.build.retail.8w"
                    mouseover   "ui.build.retail.8w.mo"
                    reqs [
                        { #type prestige-requirement value 14 }
                    ]

                    action      placetemplate
                    values      [ "emptyspace-retail-8w" ]
                }
                ] ;; elements
            } ] ;; tabs
        }

        {
            id      "subribbon-services"
            tabs    [ {
                tabheader       "ui.build.services.text"
                elements    [
                {
                    type        button
                    locname     "ui.build.services.office"
                    mouseover   "ui.build.services.office.mo"
                    reqs        [
                    ]

                    action      callback
                    values      [ buyservice officeservice ]
                }
                {
                    type        button
                    locname     "ui.build.services.residential"
                    mouseover   "ui.build.services.residential.mo"
                    reqs [
                    ]

                    action      callback
                    values      [ buyservice residentialservice ]
                }
                {
                    type        button
                    locname     "ui.build.vending"
                    mouseover   "ui.build.vending.mo"
                     reqs [ { #type prestige-requirement value 1 } ]

                    action      callback
                    values      [ buyvending ]
                }

                ] ;; elements
            } ] ;; tabs
        }


        {
            id      "subribbon-art"
            tabs    [

            
            ;; small art tab
            {
                id              "subribbon-art-small"
                tabname         "ui.build.art.tab.small"
                tabheader       "ui.build.art.small.text"
                elements [
                {
                    type        text
                    locname     "ui.build.art.paintings.text"
                }
                {
                    type        buttonpreview
                    locname     "ui.build.art.paintings.small.one"
                    mouseover   "ui.build.art.paintings.small.mo"

                    action      placetemplate
                    values      [ "painting-small-one" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.art.paintings.small.two"
                    mouseover   "ui.build.art.paintings.small.mo"

                    action      placetemplate
                    values      [ "painting-small-two" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.art.paintings.small.three"
                    mouseover   "ui.build.art.paintings.small.mo"

                    action      placetemplate
                    values      [ "painting-small-three" ]
                }
                {
                    type        text
                    locname     "ui.build.art.sculpture.text"
                }
                {
                    type        buttonpreview
                    locname     "ui.build.art.sculpture.small.one"
                    mouseover   "ui.build.art.sculpture.small.mo"

                    action      placetemplate
                    values      [ "sculpture-small-one" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.art.sculpture.small.two"
                    mouseover   "ui.build.art.sculpture.small.mo"

                    action      placetemplate
                    values      [ "sculpture-small-two" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.art.sculpture.small.three"
                    mouseover   "ui.build.art.sculpture.small.mo"

                    action      placetemplate
                    values      [ "sculpture-small-three" ]
                }
                ] ;; elements
            }


            ;; medium pieces tab
            {
                id              "subribbon-art-medium"
                tabname         "ui.build.art.tab.medium"
                tabheader       "ui.build.art.medium.text"
                elements [
                 {
                    type        text
                    locname     "ui.build.art.paintings.text"
                }
                {
                    type        buttonpreview
                    locname     "ui.build.art.paintings.medium.one"
                    mouseover   "ui.build.art.paintings.medium.mo"

                    action      placetemplate
                    values      [ "painting-medium-one" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.art.paintings.medium.two"
                    mouseover   "ui.build.art.paintings.medium.mo"

                    action      placetemplate
                    values      [ "painting-medium-two" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.art.paintings.medium.three"
                    mouseover   "ui.build.art.paintings.medium.mo"

                    action      placetemplate
                    values      [ "painting-medium-three" ]
                }
                {
                    type        text
                    locname     "ui.build.art.sculpture.text"
                }
                {
                    type        buttonpreview
                    locname     "ui.build.sculpture.medium.one"
                    mouseover   "ui.build.sculpture.medium.mo"

                    action      placetemplate
                    values      [ "sculpture-medium-one" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.sculpture.medium.two"
                    mouseover   "ui.build.sculpture.medium.mo"

                    action      placetemplate
                    values      [ "sculpture-medium-two" ]
                }
                ] ;; elements
            }

             ;; big pieces tab
            {
                id              "subribbon-art-large"
                tabname         "ui.build.art.tab.large"
                tabheader       "ui.build.art.large.text"
                elements [
                 {
                    type        text
                    locname     "ui.build.art.paintings.text"
                }
                {
                    type        buttonpreview
                    locname     "ui.build.art.mural"
                    mouseover   "ui.build.art.mural.mo"

                    action      placetemplate
                    values      [ "painting-mural" ]
                }
                {
                    type        text
                    locname     "ui.build.art.sculpture.text"
                }
                {
                    type        buttonpreview
                    locname     "ui.build.art.sculpture.large.inside"
                    mouseover   "ui.build.art.sculpture.large.inside.mo"

                    action      placetemplate
                    values      [ "sculpture-large-inside" ]
                }
                ] ;; elements
            }
             ;; fountains tab
            {
                id              "subribbon-art-fountains"
                tabname         "ui.build.art.tab.fountains"
                tabheader       "ui.build.art.fountains.text"
                elements [
                {
                    type        buttonpreview
                    locname     "ui.build.art.fountain.indoor.one"
                    mouseover   "ui.build.art.fountain.indoor.one.mo"

                    action      placetemplate
                    values      [ "fountain-indoor-one" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.art.fountain.indoor.two"
                    mouseover   "ui.build.art.fountain.indoor.two.mo"

                    action      placetemplate
                    values      [ "fountain-indoor-two" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.art.fountain.indoor.three"
                    mouseover   "ui.build.art.fountain.indoor.three.mo"

                    action      placetemplate
                    values      [ "fountain-indoor-three" ]
                }
                ] ;; elements
            }

            ;; outside tab
            {
                id              "subribbon-art-outside"
                tabname         "ui.build.art.tab.outside"
                tabheader       "ui.build.art.outside.text"
                elements [
                {
                    type        text
                    locname     "ui.build.art.outside.sculpture"
                }
                {
                    type        buttonpreview
                    locname     "ui.build.statue.one"
                    mouseover   "ui.build.statue.mo"

                    action      placetemplate
                    values      [ "statue-outdoor-one" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.statue.two"
                    mouseover   "ui.build.statue.mo"

                    action      placetemplate
                    values      [ "statue-outdoor-two" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.statue.three"
                    mouseover   "ui.build.statue.mo"

                    action      placetemplate
                    values      [ "statue-outdoor-three" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.statue.four"
                    mouseover   "ui.build.statue.mo"

                    action      placetemplate
                    values      [ "statue-outdoor-four" ]
                }
                {
                    type        text
                    locname     "ui.build.art.outside.fountains"
                }
                {
                    type        buttonpreview
                    locname     "ui.build.outdoor.fountain.one"
                    mouseover   "ui.build.outdoor.fountain.mo"

                    action      placetemplate
                    values      [ "plaza-fountain-one" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.outdoor.fountain.two"
                    mouseover   "ui.build.outdoor.fountain.mo"

                    action      placetemplate
                    values      [ "plaza-fountain-two" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.outdoor.fountain.three"
                    mouseover   "ui.build.outdoor.fountain.mo"

                    action      placetemplate
                    values      [ "plaza-fountain-three" ]
                }
                
                ] ;; elements

            }
            {
                id              "subribbon-decos-plazas"
                tabname         "ui.build.plazas"
                tabheader       "ui.build.plazas.header"
                elements [
                {
                    type        buttonpreview
                    locname     "ui.build.plaza.tile"
                    mouseover   "ui.build.plaza.tile.mo"
                    reqs [
                        { #type consultant-upgrade-requirement id "cons-b-2" }
                    ]

                    action      placetemplate
                    values      [ "deco-plaza-tile" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.plaza.hedge.single"
                    mouseover   "ui.build.plaza.hedge.single.mo"
                    reqs [
                        { #type consultant-upgrade-requirement id "cons-b-2" }
                    ]

                    action      placetemplate
                    values      [ "deco-plaza-single-hedge" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.plaza.hedge.double"
                    mouseover   "ui.build.plaza.hedge.double.mo"
                    reqs [
                        { #type consultant-upgrade-requirement id "cons-b-2" }
                    ]

                    action      placetemplate
                    values      [ "deco-plaza-double-hedge" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.plaza.hedge.triple"
                    mouseover   "ui.build.plaza.hedge.triple.mo"
                    reqs [
                        { #type consultant-upgrade-requirement id "cons-b-2" }
                    ]

                    action      placetemplate
                    values      [ "deco-plaza-triple-hedge" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.plaza.bench.single"
                    mouseover   "ui.build.plaza.bench.single.mo"
                    reqs [
                        { #type consultant-upgrade-requirement id "cons-b-2" }
                    ]

                    action      placetemplate
                    values      [ "deco-plaza-bench-single" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.plaza.bench.double"
                    mouseover   "ui.build.plaza.bench.double.mo"
                    reqs [
                        { #type consultant-upgrade-requirement id "cons-b-2" }
                    ]

                    action      placetemplate
                    values      [ "deco-plaza-bench-double" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.plaza.bench.triple"
                    mouseover   "ui.build.plaza.bench.triple.mo"
                    reqs [
                        { #type consultant-upgrade-requirement id "cons-b-2" }
                    ]

                    action      placetemplate
                    values      [ "deco-plaza-bench-triple" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.plaza.tree.small"
                    mouseover   "ui.build.plaza.tree.small.mo"
                    reqs [
                        { #type consultant-upgrade-requirement id "cons-b-2" }
                    ]

                    action      placetemplate
                    values      [ "deco-plaza-tree-small" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.plaza.tree.medium"
                    mouseover   "ui.build.plaza.tree.medium.mo"
                    reqs [
                        { #type consultant-upgrade-requirement id "cons-b-2" }
                    ]

                    action      placetemplate
                    values      [ "deco-plaza-tree-medium" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.plaza.tree.large"
                    mouseover   "ui.build.plaza.tree.large.mo"
                    reqs [
                        { #type consultant-upgrade-requirement id "cons-b-2" }
                    ]

                    action      placetemplate
                    values      [ "deco-plaza-tree-large" ]
                }
                ]
            }
            ] ;; tabs
        }

        {
            id      "subribbon-decos"
            tabs    [

            ;; wallpaper tab
            {
                id              "subribbon-decos-wallpaper"
                tabname         "ui.build.decos.wallpaer"
                tabheader       "ui.build.wall.header"
                elements [
                {
                    type        buttonpreview
                    locname     "ui.build.wall.wallpaper.one"
                    mouseover   "ui.build.wall.wallpaper.one.mo"
                    action      callback
                    values      [ wallpaper plain ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.wall.wallpaper.two"
                    mouseover   "ui.build.wall.wallpaper.two.mo"
                    action      callback
                    values      [ wallpaper chairrail ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.wall.wallpaper.three"
                    mouseover   "ui.build.wall.wallpaper.three.mo"
                    action      callback
                    values      [ wallpaper fancy-one ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.wall.wallpaper.four"
                    mouseover   "ui.build.wall.wallpaper.four.mo"
                    action      callback
                    values      [ wallpaper fancy-two ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.wall.glass"
                    mouseover   "ui.build.wall.glass.mo"
                    action      callback
                    values      [ wallpaper glass ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.wall.glass.double"
                    mouseover   "ui.build.wall.glass.double.mo"
                    action      callback
                    values      [ wallpaper glass-double ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.wall.remove"
                    mouseover   "ui.build.wall.remove.mo"
                    action      callback
                    values      [ wallpaper #null ]
                }
                ] ;; elements

            }
            {
                id              "subribbon-decos-furniture"
                tabname         "ui.build.furniture"
                tabheader       "ui.build.furniture.header"
                elements [
                {
                    type        text
                    locname     "ui.build.furniture.seating"
                }
                {
                    type        buttonpreview
                    locname     "ui.build.furniture.seating.blue"
                    mouseover   "ui.build.furniture.seating.blue.mo"

                    action      placetemplate
                    values      [ "deco-seating-green" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.furniture.seating.green"
                    mouseover   "ui.build.furniture.seating.green.mo"

                    action      placetemplate
                    values      [ "deco-seating-orange" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.furniture.seating.orange"
                    mouseover   "ui.build.furniture.seating.orange.mo"

                    action      placetemplate
                    values      [ "deco-seating-blue" ]
                }
                {
                    type        text
                    locname     "ui.build.furniture.cabinets"
                }
                {
                    type        buttonpreview
                    locname     "ui.build.furniture.cabinets.twodrawers"
                    mouseover   "ui.build.furniture.cabinets.darkbrown.mo"

                    action      placetemplate
                    values      [ "deco-furniture-cabinet-darkbrown" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.furniture.cabinets.lightbrown"
                    mouseover   "ui.build.furniture.cabinets.lightbrown.mo"

                    action      placetemplate
                    values      [ "deco-furniture-cabinet-lightbrown" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.furniture.cabinets.darkbrown"
                    mouseover   "ui.build.furniture.cabinets.twodrawers.mo"

                    action      placetemplate
                    values      [ "deco-furniture-cabinet-twodrawers" ]
                }
                
                ]
            }
            {
                id              "subribbon-decos-plants"
                tabname         "ui.build.plants"
                tabheader       "ui.build.plants.header"
                elements [
                {
                    type        buttonpreview
                    locname     "ui.build.plants.ficus"
                    mouseover   "ui.build.plants.ficus.mo"

                    action      placetemplate
                    values      [ "deco-plant-ficus" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.plants.palm"
                    mouseover   "ui.build.plants.palm.mo"

                    action      placetemplate
                    values      [ "deco-plant-palm" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.plants.one"
                    mouseover   "ui.build.plants.one.mo"

                    action      placetemplate
                    values      [ "deco-plant-one" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.plants.two"
                    mouseover   "ui.build.plants.two.mo"

                    action      placetemplate
                    values      [ "deco-plant-two" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.plants.three"
                    mouseover   "ui.build.plants.three.mo"

                    action      placetemplate
                    values      [ "deco-plant-three" ]
                }
                ]
            }
            {
                id              "subribbon-decos-lighting"
                tabname         "ui.build.lighting"
                tabheader       "ui.build.lighting.header"
                elements [
                {
                    type        buttonpreview
                    locname     "ui.build.lighting.globes"
                    mouseover   "ui.build.lighting.globes.mo"

                    action      placetemplate
                    values      [ "deco-light-globes" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.lighting.sconce"
                    mouseover   "ui.build.lighting.sconce.mo"

                    action      placetemplate
                    values      [ "deco-light-sconce" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.lighting.green"
                    mouseover   "ui.build.lighting.green.mo"

                    action      placetemplate
                    values      [ "deco-light-green" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.lighting.fluorescent"
                    mouseover   "ui.build.lighting.fluorescent.mo"

                    action      placetemplate
                    values      [ "deco-light-fluorescent" ]
                }
                ]
            }
            {
                id              "subribbon-decos-misc"
                tabname         "ui.build.misc"
                tabheader       "ui.build.misc.header"
                elements [
                {
                    type        buttonpreview
                    locname     "ui.build.misc.clock"
                    mouseover   "ui.build.misc.clock.mo"

                    action      placetemplate
                    values      [ "deco-misc-clock" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.misc.sunclock"
                    mouseover   "ui.build.misc.sunclock.mo"

                    action      placetemplate
                    values      [ "deco-misc-sunclock" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.misc.trashcan"
                    mouseover   "ui.build.misc.trashcan.mo"

                    action      placetemplate
                    values      [ "deco-misc-trashcan" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.misc.water"
                    mouseover   "ui.build.misc.water.mo"

                    action      placetemplate
                    values      [ "deco-misc-water" ]
                }
                ]
            }
            {
                id              "subribbon-decos-preorder"
                tabname         "ui.build.preorder"
                tabheader       "ui.build.preorder.header"
                visreqs [ { #type pack-requirement id preorder } ]
                elements [
                {
                    type        buttonpreview
                    locname     "ui.build.wall.wallpaper.marble"
                    mouseover   "ui.build.wall.wallpaper.marble.mo"
                    action      callback
                    values      [ wallpaper marble ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.preorder.chair-brno"
                    mouseover   "ui.build.preorder.chair-brno.mo"

                    action      placetemplate
                    values      [ "deco-preorder-chair-brno" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.preorder.chair-barcelona"
                    mouseover   "ui.build.preorder.chair-barcelona.mo"

                    action      placetemplate
                    values      [ "deco-preorder-chair-barcelona" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.preorder.light"
                    mouseover   "ui.build.preorder.light.mo"

                    action      placetemplate
                    values      [ "deco-preorder-light-standing" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.preorder.statue"
                    mouseover   "ui.build.preorder.statue.mo"

                    action      placetemplate
                    values      [ "deco-preorder-statue" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.preorder.table"
                    mouseover   "ui.build.preorder.table.mo"

                    action      placetemplate
                    values      [ "deco-preorder-table" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.preorder.fountain"
                    mouseover   "ui.build.preorder.fountain.mo"

                    action      placetemplate
                    values      [ "deco-preorder-fountain" ]
                }
                ]
            }
            {
                id              "subribbon-decos-fall"
                tabname         "ui.build.seasonal.fall"
                tabheader       "ui.build.seasonal.fall.header"
            ;    visreqs [ { #type pack-requirement id preorder } ]
                elements [
                {
                    type        buttonpreview
                    locname     "ui.build.seasonal.pumpkins"
                    mouseover   "ui.build.seasonal.pumpkins.mo"

                    action      placetemplate
                    values      [ "deco-fall-pumpkins" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.seasonal.skullcandle"
                    mouseover   "ui.build.seasonal.skullcandle.mo"

                    action      placetemplate
                    values      [ "deco-fall-skullcandles" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.seasonal.chair"
                    mouseover   "ui.build.seasonal.chair.mo"

                    action      placetemplate
                    values      [ "deco-fall-chair" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.seasonal.candles"
                    mouseover   "ui.build.seasonal.candles.mo"

                    action      placetemplate
                    values      [ "deco-fall-candles" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.seasonal.turkey"
                    mouseover   "ui.build.seasonal.turkey.mo"

                    action      placetemplate
                    values      [ "deco-fall-turkey" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.seasonal.cobwebs.left"
                    mouseover   "ui.build.seasonal.cobwebs.left.mo"

                    action      placetemplate
                    values      [ "deco-fall-cobwebs-left" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.seasonal.cobwebs.right"
                    mouseover   "ui.build.seasonal.cobwebs.right.mo"

                    action      placetemplate
                    values      [ "deco-fall-cobwebs-right" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.seasonal.wreath"
                    mouseover   "ui.build.seasonal.wreath.mo"

                    action      placetemplate
                    values      [ "deco-fall-wreath" ]
                }
                ]
            }
            {
                id              "subribbon-decos-winter"
                tabname         "ui.build.seasonal.winter"
                tabheader       "ui.build.seasonal.winter.header"
            ;    visreqs [ { #type pack-requirement id preorder } ]
                elements [
                {
                    type        buttonpreview
                    locname     "ui.build.seasonal.xmastree"
                    mouseover   "ui.build.seasonal.xmastree.mo"

                    action      placetemplate
                    values      [ "deco.seasonal.winter.xmastree" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.seasonal.xmastree.outside"
                    mouseover   "ui.build.seasonal.xmastree.outside.mo"

                    action      placetemplate
                    values      [ "deco.seasonal.winter.xmastree.outside" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.seasonal.winter.chair"
                    mouseover   "ui.build.seasonal.winter.chair.mo"

                    action      placetemplate
                    values      [ "deco.winter.chair" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.seasonal.winter.light"
                    mouseover   "ui.build.seasonal.winter.light.mo"

                    action      placetemplate
                    values      [ "deco.winter.light" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.seasonal.menorah"
                    mouseover   "ui.build.seasonal.menorah.mo"

                    action      placetemplate
                    values      [ "deco.winter.menorah" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.seasonal.mistletoe"
                    mouseover   "ui.build.seasonal.mistletoe.mo"

                    action      placetemplate
                    values      [ "deco.winter.mistletoe" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.seasonal.winter.tree"
                    mouseover   "ui.build.seasonal.winter.tree.mo"

                    action      placetemplate
                    values      [ "deco.winter.tree" ]
                }
                ]
            }
            ] ;; tabs
        }
         {
                id                 "subribbon-consultants"

                tabs [ {
                id              "subribbon-consultants-art"
                tabname         "ui.build.consultants.art"    
                tabheader       "ui.build.consultants.art.header"
                elements [
                {
                    type        buttonpreview
                    locname     "ui.build.consultants.art.decorator"
                    mouseover   "ui.build.consultants.art.decorator.mo"

                    action      placetemplate
                    values      [ "consultant-aesthetics" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.consultants.art.dealer"
                    mouseover   "ui.build.consultants.art.dealer.mo"

                    action      placetemplate
                    values      [ "consultant-aesthetics-dealer" ]
                }
                {
                    type        buttonpreview
                    locname     "ui.build.consultants.art.gallery"
                    mouseover   "ui.build.consultants.art.gallery.mo"

                    action      placetemplate
                    values      [ "consultant-aesthetics-gallery" ]
                }
                ] 
                }
                {
                id          "subribbon-consultants-politics"
                tabname     "ui.build.consultants.politics"
                tabheader   "ui.build.consultants.politics.header"
                elements [
                {
                    type        buttonpreview
                    locname     "ui.build.consultants.politics.lobbyist"
                    mouseover   "ui.build.consultants.politics.lobbyist.mo"

                    action      placetemplate
                    values      [ "consultant-civics" ]
                }
                    ]
                }
                {
                id          "subribbon-consultants-operations"
                tabname     "ui.build.consultants.building"
                tabheader   "ui.build.consultants.building.header"
                elements [
                {
                    type        buttonpreview
                    locname     "ui.build.consultants.building.manager"
                    mouseover   "ui.build.consultants.building.manager.mo"

                    action      placetemplate
                    values      [ "consultant-building" ]
                }    
                ]
                }
                ]
            }



        ] ;; subribbons
    }

    infodialog {
        definitions [
            {
                units [ office restaurant retail service residence civic consultant ]
                modules [
                    {
                        #type module-name-and-info

                        customname #true
                        configname #true
                        configdescription #true
                        operatingcosts #true
                        repaircleanbutton #true
                        satisfaction #true
                    }
                ]
            }
            {
                units [ deco closet floor support infrastructure trash spawner ]
                modules [
                    {
                        #type module-name-and-info

                        customname #true
                        configname #true
                        configdescription #true
                        operatingcosts #true
                        repaircleanbutton #true
                    }
                ]
            }
            {
                units [ vending custodian ]
                modules [
                    {
                        #type module-name-and-info

                        customname #true
                        configname #true
                        configdescription #true
                        operatingcosts #true
                        repaircleanbutton #true
                        justsatinfobutton #true
                    }
                ]
            }
            {
                units [ office restaurant retail service civic consultant ]
                modules [
                    {
                        #type module-workplace-info

                        numpeople #true
                        rent #true
                        workhours #true
                        cycleworkers #true
                    }
                ]
            }
            {
                units [ residence ]
                modules [
                    {
                        #type module-workplace-info

                        numpeople #true
                        rent #true
                        cycleresidents #true
                    }
                ]
            }
;            {
;                units [ office residence ]
;                modules [
;                    {
;                        #type module-static-rent
;
;                        rent #true
;                        explanation #true
;                    }
;                ]
;            }
            {
                units [ restaurant retail ] ;; service
                modules [
                    {
                        #type module-variable-rent
                    }
                ]
            }
            {
                units [ trash ]
                modules [
                    {
                        #type module-epilogue
                    }
                ]
            }
            {
                units [ closet ]
                modules [
                    {
                        #type module-epilogue

                        utilityprovided #true
                        evictbutton #true
                        adabutton #true
                    }
                ]
            }
            {
                units [ office restaurant retail service residence ]
                modules [
                    {
                        #type module-epilogue

                        evictbutton #true
                    }
                ]
            }
            {
                units [ civic consultant deco spawner vending custodian ]
                modules [
                    {
                        #type module-epilogue

                        evictbutton #true
                    }
                ]
            }
            {
                units [ support ]
                modules [
                    {
                        #type module-epilogue

                        evictbutton #true
                        mayberenovate #true
                    }
                ]
            }
            {
                units [ infrastructure ]
                modules [
                    {
                        #type module-epilogue

                        breakagetext #true
                        evictbutton #true
                    }
                ]
            }
        ]
    }

    cheats {
        unlimited {
            cash 1000000
            prestige 100
            buzz 10000
            influence 10000
        }
    }
}
